//------------------------------------------------------------------------------------------------
// ===========================================================================
//  A CComplex.h                               2001 January 30  -  VERSION 1.0
// ===========================================================================
//    This header file defines the complex number object
//
//    Copyright (c) 2001 Dr. Brian Biswell
//    All rights reserved.  Permission is granted to freely use and distribute
//      this routine for non-profit use provided this notice remains intact.
//
//
//    REVISION HISTORY:
//      1.0  2001/01/30 - Original version by Brian Biswell
//
//------------------------------------------------------------------------------------------------
#ifndef __CCOMPLEX_H
#define __CCOMPLEX_H

#include <stdio.h>
#include <math.h>
#ifdef __BORLANDC__
#include <System.hpp>
#endif
#include <astring.h>

//#define M_E         2.71828182845904523536
#define M_PI        3.14159265358979323846

//------------------------------------------------------------------------------------------------
// ===========================================================================
//  A CComplex
// ===========================================================================
//
//    This class defines the complex number type and its operators
//
//------------------------------------------------------------------------------------------------
class CComplex;

CComplex polar (const double& r, const double& theta);
CComplex conj  (const CComplex& z);
double  angle (const CComplex& z);
double  arg (const CComplex& z);
double  real  (const CComplex& z);
double  imag  (const CComplex& z);
CComplex sign  (const CComplex& z);
      
CComplex sin(const CComplex& z);
CComplex sinh  (const CComplex& z);
CComplex asin  (const CComplex& z);
CComplex asinh (const CComplex& z);
CComplex cos   (const CComplex& z);
CComplex cosh  (const CComplex& z);
CComplex acos  (const CComplex& z);
CComplex acosh (const CComplex& z);
CComplex tan   (const CComplex& z);
CComplex tanh  (const CComplex& z);
CComplex atan  (const CComplex& z);
CComplex atanh (const CComplex& z);
CComplex sec   (const CComplex& z);
CComplex sech  (const CComplex& z);
CComplex asec  (const CComplex& z);
CComplex asech (const CComplex& z);
CComplex csc   (const CComplex& z);
CComplex csch  (const CComplex& z);
CComplex acsc  (const CComplex& z);
CComplex acsch (const CComplex& z);
CComplex cot   (const CComplex& z);
CComplex coth  (const CComplex& z);
CComplex acot  (const CComplex& z);
CComplex acoth (const CComplex& z);
      
CComplex exp( const CComplex& );				
double  abs   (const CComplex& z);
CComplex ln    (const CComplex& z);
CComplex log   (const CComplex& z);
CComplex log10 (const CComplex& z);

CComplex pow( const CComplex& v, double& expon );
CComplex pow( double& v, const CComplex& expon );
CComplex pow( const CComplex& v, const CComplex& expon );
      
CComplex sqrt  (const CComplex& z);

CComplex fix   (const CComplex& z);
CComplex floor (const CComplex& z);
CComplex ceil  (const CComplex& z);
CComplex round (const CComplex& z);
CComplex round( const CComplex& z, int prec );

//------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------
class CComplex
{
	public:
		// Constructor and destructor:
		CComplex( void ) : mReal( 0.0 ), mImag( 0.0 ) {} // Empty constructor
		CComplex( double r, double i ) : mReal(r), mImag(i) {}		// Constructor
		~CComplex() {}												// Destructor
		
		// Access functions:
		double	real() const { return mReal; }		// Returns Real part of number
		double	imag() const { return mImag; }		// Returns Imaginary part of number 
		bool     iszero() const { return ( mReal == 0.0 && mImag == 0.0 ); }  // CComplex equal zero
		
      // String functions
      AnsiString ToString( void ) const;
      int Save( FILE* f );
      int Load( FILE* f );

		// Operators
		CComplex& operator+=(const CComplex& z);
		CComplex& operator+=(const double&  x);
		CComplex& operator-=(const CComplex& z);
		CComplex& operator-=(const double&  x);
		CComplex& operator*=(const CComplex& z);
		CComplex& operator*=(const double&  x);
		CComplex& operator/=(const CComplex& z);
		CComplex& operator/=(const double&  x);
		CComplex operator!( void );

		operator size_t( void ) const;
		     
      friend CComplex operator+(const CComplex& z1, const CComplex& z2);
      friend CComplex operator+(const double&  x,  const CComplex& z);
      friend CComplex operator+(const CComplex& z,  const double&  x);
      friend CComplex operator-(const CComplex& z1, const CComplex& z2);
      friend CComplex operator-(const double&  x,  const CComplex& z);
      friend CComplex operator-(const CComplex& z,  const double&  x);
      friend CComplex operator*(const CComplex& z1, const CComplex& z2);
      friend CComplex operator*(const double&  x,  const CComplex& z);
      friend CComplex operator*(const CComplex& z,  const double&  x);
      friend CComplex operator/(const CComplex& z1, const CComplex& z2);
      friend CComplex operator/(const double&  x,  const CComplex& z);
      friend CComplex operator/(const CComplex& z,  const double&  x);
      friend CComplex operator+(const CComplex& z);
      friend CComplex operator-(const CComplex& z);

      friend bool operator==(const CComplex& z1, const CComplex& z2);
      friend bool operator!=(const CComplex& z1, const CComplex& z2);
      friend bool operator<(const CComplex& z1, const CComplex& z2);
      friend bool operator<=(const CComplex& z1, const CComplex& z2);
      friend bool operator>(const CComplex& z1, const CComplex& z2);
      friend bool operator>=(const CComplex& z1, const CComplex& z2);
      friend bool operator==(const double& x, const CComplex& z);
      friend bool operator!=(const double& x, const CComplex& z);
      friend bool operator<(const double& x, const CComplex& z);
      friend bool operator<=(const double& x, const CComplex& z);
      friend bool operator>(const double& x, const CComplex& z);
      friend bool operator>=(const double& x, const CComplex& z);

      friend CComplex polar (const double& r, const double& theta);
      friend CComplex conj  (const CComplex& z);
      friend double  angle (const CComplex& z);
      friend double  arg (const CComplex& z);
      friend double  real  (const CComplex& z);
      friend double  imag  (const CComplex& z);
      friend CComplex sign  (const CComplex& z);
      
      friend CComplex sin(const CComplex& z);
      friend CComplex sinh  (const CComplex& z);
      friend CComplex asin  (const CComplex& z);
      friend CComplex asinh (const CComplex& z);
      friend CComplex cos   (const CComplex& z);
      friend CComplex cosh  (const CComplex& z);
      friend CComplex acos  (const CComplex& z);
      friend CComplex acosh (const CComplex& z);
      friend CComplex tan   (const CComplex& z);
      friend CComplex tanh  (const CComplex& z);
      friend CComplex atan  (const CComplex& z);
      friend CComplex atanh (const CComplex& z);
      friend CComplex sec   (const CComplex& z);
      friend CComplex sech  (const CComplex& z);
      friend CComplex asec  (const CComplex& z);
      friend CComplex asech (const CComplex& z);
      friend CComplex csc   (const CComplex& z);
      friend CComplex csch  (const CComplex& z);
      friend CComplex acsc  (const CComplex& z);
      friend CComplex acsch (const CComplex& z);
      friend CComplex cot   (const CComplex& z);
      friend CComplex coth  (const CComplex& z);
      friend CComplex acot  (const CComplex& z);
      friend CComplex acoth (const CComplex& z);
      
      friend CComplex exp( const CComplex& );				
      friend double  abs   (const CComplex& z);
      friend CComplex ln    (const CComplex& z);
      friend CComplex log   (const CComplex& z);
      friend CComplex log10 (const CComplex& z);

      friend CComplex pow( const CComplex& v, double& expon );
      friend CComplex pow( double& v, const CComplex& expon );
      friend CComplex pow( const CComplex& v, const CComplex& expon );
      
      friend CComplex sqrt  (const CComplex& z);

      friend CComplex fix   (const CComplex& z);
      friend CComplex floor (const CComplex& z);
      friend CComplex ceil  (const CComplex& z);
      friend CComplex round (const CComplex& z);
      friend CComplex round( const CComplex& z, int prec );

	protected:
		double	mReal;		// Real part of the number
		double	mImag;		// Imaginary part of the number	
};
//------------------------------------------------------------------------------------------------
extern CComplex CCNull;
//------------------------------------------------------------------------------------------------
AnsiString ComplexToStr( const CComplex& z );
AnsiString ComplexToStrF( const CComplex& z, int prec = -1 );
AnsiString ComplexToStrE( const CComplex& z, int prec = -1 );
CComplex StrToComplex( const char* Value );
//------------------------------------------------------------------------------------------------

#endif

