//---------------------------------------------------------------------------
#include <atomutil.h>

#include <ainter.h>
#ifdef __BORLANDC__
#include "testinterpreter.h"
#endif
//---------------------------------------------------------------------------
//typedef struct nodeinfo
//{
//
//} __ninfo__;
//---------------------------------------------------------------------------
atominter::atominter( void )
{
   _casesens = false; //true;
   _exptree = new ptree();
   _const = NULL;
   _var = NULL;
   _stack = NULL;
   //flog = fopen( "ainter.log", "wt" );
	flog = NULL;
}
//---------------------------------------------------------------------------
atominter::~atominter()
{
   clearTreeData( NULL );
   delete _exptree;
   if( flog )
   {
      fclose( flog );
   }
}
//---------------------------------------------------------------------------
void atominter::clearTreeData( pnode* parent )
{
   pnode* n;
   int *i;

   if( !parent )
   {
      n = _exptree->getfirst();
   }
   else
   {
      n = parent->getfirstch();
   }
   while( n )
   {
      if( n->haschildren() )
      {
         clearTreeData( n );
      }

      if( n->getdata() && n->getdatasize() == sizeof( int ) )
      {
         i = (int*)( n->getdata() );
         delete i;
         n->setdata( 0, NULL );
      }
      n = n->getnext();
   }
}
//---------------------------------------------------------------------------
AnsiString atominter::typeToString( int type )
{
   AnsiString p;

   switch( type )
   {
      case ttUnknown:
      p = "Unknown";
      break;
      case ttInteger:
      p = "Integer";
      break;
      case ttBinInteger:
      p = "Binary Integer";
      break;
      case ttOctInteger:
      p = "Octal Integer";
      break;
      case ttHexInteger:
      p = "Hexadecimal Integer";
      break;
      case ttDouble:
      p = "Double";
      break;
      case ttExponent:
      p = "Exponent";
      break;
      case ttComplex:
      p = "Complex";
      break;
      case ttMeasure:
      p = "Measure";
      break;
      case ttString:
      p = "String";
      break;
      case ttExpression:
      p = "Expression";
      break;
      case ttSymbol:
      p = "Symbol";
      break;
      case ttFunction:
      p = "Function";
      break;
      case ttVariable:
      p = "Variable";
      break;
      case ttConstant:
      p = "Constant";
      break;
      case ttOperator:
      p = "Operator";
      break;
      case ttSeparator:
      p = "Separator";
      break;
      case ttLParenth:
      p = "Left Parenthesis";
      break;
      case ttRParenth:
      p = "Right Parenthesis";
      break;
      case ttLBracket:
      p = "Left Square Bracket";
      break;
      case ttRBracket:
      p = "Right Square Bracket";
      break;
      case ttLCurly:
      p = "Left Curly Bracket";
      break;
      case ttRCurly:
      p = "Right Curly Bracket";
      break;
      case ttSpace:
      p = "Blank character";
      break;
      default:
      p = "?";
      break;
   }
   return p;
}
//---------------------------------------------------------------------------
bool atominter::fromString( AnsiString Text )
{
   bool lResult;

   Add2Log( "Start processing[" + Text + "]...", true );
   _expstr = Text;
   
   _errorExp = "";
   _errorPos = 0;
   _errorCode = 0;

   lResult = makeTokens( Text );
   if( lResult )
   {
      Add2Log( "Before parsing..." );
      lResult = beforeParse( NULL );
   }

   if( lResult )
   {
      Add2Log( "Removing blanks..." );
      removeBlanks( NULL );
      Add2Log( "Parsing functions..." );
      lResult = parseFunctions( NULL );
   }

   if( lResult )
   {
      //Add2Log( "Parsing constants..." );
      //lResult = parseConstants( NULL );
   }

   if( lResult )
   {
      //Add2Log( "Parsing variables..." );
      //lResult = parseVariables( NULL );
   }

   if( lResult )
   {
      Add2Log( "Parsing missed operators..." );
      lResult = parseMissedOperators( NULL );
   }

   if( lResult )
   {
      Add2Log( "Parsing complex..." );
      lResult = parseComplex( NULL );
   }

   if( lResult )
   {
      Add2Log( "Parsing operators..." );
      lResult = parseOperators( NULL );
   }

   if( _errorCode )
   {
      #ifdef __BORLANDC__
      _errorStr = "Error code " + Sysutils::IntToStr( _errorCode ) +
                       " at pos." + Sysutils::IntToStr( _errorPos ) +
                       " in: ..." + _expstr.SubString( _errorPos, _expstr.Length() );
      #else
      _errorStr = "Error code " + IntToStr( _errorCode ) +
                       " at pos." + IntToStr( _errorPos ) +
                       " in: ..." + _expstr.SubString( _errorPos, _expstr.Length() );
      #endif
      Add2Log( _errorStr );
   }
   return lResult;
}
//---------------------------------------------------------------------------
bool atominter::makeTokens( AnsiString Text )
{
   bool lResult = true;
   bool lExit;
   bool lStop;
   bool lDot;
   bool lExp;
   bool lError;
   int j, pos;
   int len;
   int type;
   int cparenth, cbracket, ccurly;
   char z;
   AnsiString p;
   AnsiString br;
   pnode* n;
   pnode* parent = NULL;

   clearTreeData( NULL );
   _exptree->clear();

   len = Text.Length();
   j = 1;
   pos = 0;
   cparenth = 0;
   cbracket = 0;
   ccurly = 0;
   type = ttUnknown;
   p = "";
   br = "$";
   lStop = false;
   lDot = false;
   lExp = false;
   lError = false;
   lExit = false;
   while( !lExit && !lError )
   {
      if( j > len )
      {
         lExit = true;
      }
      else
      {
         z = Text[ j ];
         if( type == ttUnknown )
         {
            pos = j;
            if( z >= '0' && z <= '9' )
            {
               type = ttInteger;
               Add2Log( "Starting Integer..." );
            }
            else if( z == '.' )
            {
               type = ttDouble;
               Add2Log( "Starting Double..." );
            }
            else if( z == '#' )
            {
               type = ttBaseSign;
               Add2Log( "Starting some Integer format..." );
            }
            else if( ( z >= 'A' && z <= 'Z' ) || ( z >= 'a' && z <= 'z' ) )
            {
               type = ttSymbol;
               Add2Log( "Starting Symbol..." );
            }
            else if( z == '+' || z == '-' || z == '*' || z == '/' || z == '^' ||
                     z == '%' || z == '&' || z == '|' || z == ':' || z == '=' ||
                     z == '<' || z == '>' )
            {
               type = ttOperator;
               Add2Log( "Starting Operator " + AnsiString( z ) );
               //lStop = true;
            }
            else if( z == '\"' )
            {
               type = ttString;
               Add2Log( "Starting String..." );
            }
            else if( z == '\'' )
            {
               type = ttExpression;
               Add2Log( "Starting Expression..." );
            }
            else if( z == '_' )
            {
               type = ttMeasure;
               Add2Log( "Starting Measure..." );
            }
            else if( z == '(' )
            {
               type = ttLParenth;
               br = "(" + br;
               Add2Log( "Getting Left Parenth... " + AnsiString( z ) );
               cparenth++;
            }
            else if( z == ')' )
            {
               type = ttRParenth;
               Add2Log( "Getting Right Parenth... " + AnsiString( z ) );
               cparenth--;
               if( cparenth < 0 || br.Length() == 1 || br[ 1 ] != '(' )
               {
                  lError = true;
                  _errorCode = 2;
                  _errorPos = j;
               }
               else
               {
                  br = br.SubString( 2, br.Length() );
               }
            }
            else if( z == '[' )
            {
               type = ttLBracket;
               br = "[" + br;
               Add2Log( "Getting Left Bracket... " + AnsiString( z ) );
               cbracket++;
            }
            else if( z == ']' )
            {
               type = ttRBracket;
               Add2Log( "Getting Right Bracket... " + AnsiString( z ) );
               cbracket--;
               if( cbracket < 0 || br.Length() == 1 || br[ 1 ] != '[' )
               {
                  lError = true;
                  _errorCode = 3;
                  _errorPos = j;
               }
               else
               {
                  br = br.SubString( 2, br.Length() );
               }
            }
            else if( z == '{' )
            {
               type = ttLCurly;
               br = "{" + br;
               Add2Log( "Getting Left Curly... " + AnsiString( z ) );
               ccurly++;
            }
            else if( z == '}' )
            {
               type = ttRCurly;
               Add2Log( "Getting Right Curly... " + AnsiString( z ) );
               ccurly--;
               if( ccurly < 0 || br.Length() == 1 || br[ 1 ] != '{' )
               {
                  lError = true;
                  _errorCode = 4;
                  _errorPos = j;
               }
               else
               {
                  br = br.SubString( 2, br.Length() );
               }
            }
            else if( z == ';' || z == ',' )
            {
               type = ttSeparator;
               Add2Log( "Getting Separator... " + AnsiString( z ) );
            }
            else if( z == ' ' )
            {
               type = ttSpace;
               Add2Log( "Getting blank character..." );
            }
            else
            {
               _errorCode = 5;
               _errorPos = j;
               lError = true;
            }
         }
         else if( type == ttInteger )
         {
            if( z >= '0' && z <= '9' )
            {
            }
            else if( z == '.' && !lDot )
            {
               Add2Log( "Changing Integer to Double..." );
               type = ttDouble;
               lDot = true;
            }
            else if( z == 'e' || z == 'E' )
            {
               type = ttExponent;
               lExp = true;
            }
            else if( z == '_' )
            {
               type = ttMeasure;
            }
            else
            {
               lStop = true;
            }
         }
         else if( type == ttBaseSign )
         {
            if( z == 'b' || z == 'B' )
            {
               Add2Log( "Changing to BIN Integer..." );
               type = ttBinInteger;
            }
            else if( z == 'o' || z == 'O' )
            {
               Add2Log( "Changing to OCT Integer..." );
               type = ttOctInteger;
            }
            else if( z == 'h' || z == 'H' )
            {
               Add2Log( "Changing to HEX Integer..." );
               type = ttHexInteger;
            }
            else
            {
               lError = true;
               _errorCode = 1;
               _errorPos = j;
            }
         }
         else if( type == ttBinInteger )
         {
            if( z =='0' || z == '1' )
            {
            }
            else
            {
               lStop = true;
            }
         }
         else if( type == ttOctInteger )
         {
            if( z >= '0' && z <= '7' )
            {
            }
            else
            {
               lStop = true;
            }
         }
         else if( type == ttHexInteger )
         {
            if( ( z >= '0' && z <= '9' ) ||
                ( z >= 'a' && z <= 'f' ) ||
                ( z >= 'A' && z <= 'F' ) )
            {
            }
            else
            {
               lStop = true;
            }
         }
         else if( type == ttDouble )
         {
            if( z >= '0' && z <= '9' )
            {
            }
            else if( z == '.' )
            {
               if( !lDot )
               {
                  lDot = true;
               }
               else
               {
                  lError = true;
                  _errorCode = 1;
                  _errorPos = j;
               }
            }
            else if( z == 'e' || z == 'E' )
            {
               type = ttExponent;
               lExp = true;
            }
            else if( z == '_' )
            {
               type = ttMeasure;
            }
            else
            {
               lStop = true;
            }
         }
         else if( type == ttExponent )
         {
            if( z >= '0' && z <= '9' )
            {
            }
            else if( z == '-' && ( Text[ j - 1 ] == 'e' || Text[ j - 1 ] == 'E' ) )
            {
            }
            else if( z == '_' )
            {
               type = ttMeasure;
            }
            else
            {
               lStop = true;
            }
         }
         else if( type == ttMeasure )
         {
            if( ( z >= 'a' && z <= 'z' ) ||
                ( z >= 'A' && z >= 'Z' ) ||
                ( z >= '0' && z <= '9' ) ||
                z == '/' || z == '^' || z == '*'
              )
            {
            }
            else
            {
               lStop = true;
            }
         }
         else if( type == ttOperator || type == ttSeparator ||
                  type == ttLParenth || type == ttRParenth ||
                  type == ttLBracket || type == ttRBracket ||
                  type == ttLCurly || type == ttRCurly ||
                  type == ttSpace
                )
         {
            lStop = true;
         }
         else if( type == ttSymbol )
         {
            if( ( z >= 'A' && z <= 'Z' ) || ( z >= 'a' && z <= 'z' ) )
            {
            }
            else
            {
               lStop = true;
            }
         }
         else if( type == ttString )
         {
            if( z == '\"' )
            {
               p += AnsiString( z );
               j++;
               lStop = true;
            }
         }
         else if( type == ttExpression )
         {
            if( z == '\'' )
            {
               p += AnsiString( z );
               j++;
               lStop = true;
            }
         }
         else
         {
         }

         if( lStop )
         {
            n = new pnode( p.c_str() );
            if( type == ttSymbol )
            {
               if( isfunc( p.c_str() ) )
               {
                  type = ttFunction;
               }
               else if( isconst( p.c_str() ) )
               {
                  type = ttConstant;
               }
               else if( isvar( p.c_str() ) )
               {
                  type = ttVariable;
               }
            }
            n->settag( type );
            n->setdata( sizeof( int ), new int( pos ) );
            if( type == ttLParenth || type == ttLBracket || type == ttLCurly )
            {
               _exptree->addnode( n, parent );
               parent = n;
            }
            else if( type == ttRParenth || type == ttRBracket || type == ttRCurly )
            {
               if( parent )
               {
                  _exptree->addnode( n, parent );
                  parent = parent->getparent();
               }
            }
            else
            {
               _exptree->addnode( n, parent );
            }
            lStop = false;
            lDot = false;
            p = "";
            pos = 0;
            type = ttUnknown;
         }
         else
         {
            p += AnsiString( z );
            if( lError )
            {
               _errorExp = p;
            }
            j++;
         }
      }

      if( lExit && p.Length() > 0 )
      {
         n = new pnode( p.c_str() );
         if( type == ttSymbol )
         {
            if( isfunc( p.c_str() ) )
            {
               type = ttFunction;
            }
            else if( isconst( p.c_str() ) )
            {
               type = ttConstant;
            }
            else if( isvar( p.c_str() ) )
            {
               type = ttVariable;
            }
         }
         n->settag( type );
         n->setdata( sizeof( int ), new int( pos ) );
         _exptree->addnode( n, parent );
      }
   }

   if( lError )
   {
      lResult = false;
      Add2Log( "Error constructing expression tree!" );
   }
   else
   {
      Add2Log( "Expression tree is OK!" );
   }

   return lResult;
}
//---------------------------------------------------------------------------
bool atominter::isfunc( const char* text )
{
   return ( _stack ? ( _stack->isfunc( text, _casesens ) > -1 ? true : false ) : false );
}
//---------------------------------------------------------------------------
bool atominter::isconst( const char* text )
{
   return ( _const ? ( _const->findAtom( text, _casesens ) > -1 ? true : false ) : false );
}
//---------------------------------------------------------------------------
bool atominter::isvar( const char* text )
{
   return ( _var ? ( _var->findAtom( text, _casesens ) > -1 ? true : false ) : false );
}
//---------------------------------------------------------------------------
bool atominter::beforeParse( pnode* parent )
{
   bool lResult = true;

	if( parent )
	{
	}
   return lResult;
}
//---------------------------------------------------------------------------
void atominter::removeBlanks( pnode* parent )
{
   pnode* n;
   pnode* p;

   n = _exptree->getfirstch( parent );
   while( n )
   {
      if( n->haschildren() )
      {
         removeBlanks( n );
      }

      if( n->gettag() == ttSpace ) //|| n->gettag() == ttSeparator )
      {
         p = n;
         n = n->getnext();
         _exptree->delnode( p );
      }
      else
      {
         n = n->getnext();
      }
   }
}
//---------------------------------------------------------------------------
bool atominter::parseFunctions( pnode* parent )
{
   bool lResult = true;
   pnode* n;
   pnode* r;

   if( _stack )
   {
      n = _exptree->getfirstch( parent );
      while( n && lResult )
      {
         if( ( n->gettag() == ttLParenth || n->gettag() == ttLBracket ) && n->count() )
         {
            lResult = parseFunctions( n );
         }
         n = n->getnext();
      }

      n = _exptree->getfirstch( parent );
      while( n && lResult )
      {
         /*
         if( n->gettag() == ttSymbol || n->gettag() == ttFunction )
         {
            if( _stack->isfunc( n->getText(), _casesens ) != -1 )
            {
               n->settag( ttFunction );
               r = n->getnext();
               if( r )
               {
                  if( r->gettag() == ttLParenth )
                  {
                     r->moveto( n );
                  }
               }
            }
         }
         */
         if( n->gettag() == ttFunction )
         {
            r = n->getnext();
            if( r )
            {
               if( r->gettag() == ttLParenth )
               {
                  r->moveto( n );
               }
            }
         }
         n = n->getnext();
      }
   }
   else
   {
      lResult = false;
   }
   return lResult;
}
//---------------------------------------------------------------------------
bool atominter::parseConstants( pnode* parent )
{
   bool lResult = true;
   pnode* n;

   if( _const )
   {
      n = _exptree->getfirstch( parent );
      while( n && lResult )
      {
         if( n->haschildren() )
         {
            lResult = parseConstants( n );
         }

         if( n->gettag() == ttSymbol )
         {
            if( _const->findAtom( n->getText() ) != -1 )
            {
               n->settag( ttConstant );
            }
         }
         n = n->getnext();
      }
   }
   else
   {
      //lResult = false;
   }
   return lResult;
}
//---------------------------------------------------------------------------
bool atominter::parseVariables( pnode* parent )
{
   bool lResult = true;
   pnode* n;

   if( _var )
   {
      n = _exptree->getfirstch( parent );
      while( n && lResult )
      {
         if( n->haschildren() )
         {
            lResult = parseVariables( n );
         }

         if( n->gettag() == ttSymbol )
         {
            if( _var->findAtom( n->getText() ) != -1 )
            {
               n->settag( ttVariable );
            }
         }
         n = n->getnext();
      }
   }
   else
   {
      //lResult = false;
   }
   return lResult;
}
//---------------------------------------------------------------------------
bool atominter::parseComplex( pnode* parent )
{
   bool lResult = true;
   pnode* n;
   pnode* p;
   pnode* x;
   int pos;

   if( _var )
   {
      n = _exptree->getfirstch( parent );
      while( n && lResult )
      {
         if( n->haschildren() )
         {
            lResult = parseComplex( n );
         }

         if( n->gettag() == ttLParenth && n->count() == 4 )
         {
               p = n->getparent();
               if( p )
               {
                  if( p->gettag() != ttFunction )
                  {
                     if( n->getdata() && n->getdatasize() == sizeof( int ) )
                     {
                        pos = *(int*)( n->getdata() );
                     }
                     else
                     {
                        pos = 0;
                     }
                     x = new pnode( "R2C" );
                     x->settag( ttFunction );
                     x->setdata( sizeof( int ), new int( pos ) );
                     _exptree->insert_node_before( x, n );
                     n->moveto( x );
                     n = x;
                  }
               }
               else
               {
                  x = new pnode( "R2C" );
                  x->settag( ttFunction );
                  _exptree->insert_node_before( x, n );
                  n->moveto( x );
                  n = x;
               }
         }
         n = n->getnext();
      }
   }
   else
   {
      //lResult = false;
   }
   return lResult;
}
//---------------------------------------------------------------------------
bool atominter::parseMissedOperators( pnode* parent )
{
   bool lResult = true;
   pnode* n;
   pnode* p;
   pnode* x;

   n = _exptree->getfirstch( parent );
   while( n )
   {
      if( n->haschildren() )
      {
         parseMissedOperators( n );
      }

      p = n;
      n = p->getnext();
      if( p && n )
      {
         int ptag = p->gettag();
         int ntag = n->gettag();

         if( ptag == ttInteger || ptag == ttDouble || ptag == ttExponent ||
             ptag == ttConstant || ptag == ttVariable || ptag == ttFunction ||
             ptag == ttRParenth )
         {
            if( ntag == ttConstant || ntag == ttVariable || ntag == ttFunction ||
                ntag == ttSymbol || ntag == ttLParenth )
            {
               x = new pnode( "*" );
               x->settag( ttOperator );
               _exptree->insert_node_after( x, p );
            }
         }
      }
   }
   return lResult;
}
//---------------------------------------------------------------------------
bool atominter::parseOperators( pnode* parent )
{
   bool lResult = true;
   pnode* n;
   pnode* l;
   pnode* r;

   if( !_exptree )
   {
      return false;
   }

   n = _exptree->getfirstch( parent );
   while( n && lResult )
   {
      //if( n->gettag() == ttLParenth && n->count() )
      if( n->haschildren() )
      {
         lResult = parseOperators( n );
      }
      n = n->getnext();
   }

   n = _exptree->getfirstch( parent );
   while( n && lResult )
   {
      if( n->gettag() == ttOperator && !n->count() &&
          ( !strcmp( n->getText(), "-" ) )
        )
      {
         l = n->getprev();
         r = n->getnext();
         if( !l && r )
         {
            n->setText( "Neg" ); //"+/-" );
            r->moveto( n );
         }
         else if( l && r )
         {
            if( l->gettag() == ttSeparator )
            {
               n->setText( "Neg" ); //"+/-" );
               r->moveto( n );
            }
         }
      }
      n = n->getnext();
   }

   n = _exptree->getfirstch( parent );
   while( n && lResult )
   {
      if( n->gettag() == ttOperator && !n->count() &&
          ( !strcmp( n->getText(), "^" ) )
        )
      {
         l = n->getprev();
         r = n->getnext();
         if( l && r )
         {
            l->moveto( n );
            r->moveto( n );
         }
      }
      n = n->getnext();
   }

   n = _exptree->getfirstch( parent );
   while( n && lResult )
   {
      if( n->gettag() == ttOperator && !n->count() &&
          ( !strcmp( n->getText(), "*" ) || !strcmp( n->getText(), "/" ) )
        )
      {
         l = n->getprev();
         r = n->getnext();
         if( l && r )
         {
            l->moveto( n );
            r->moveto( n );
         }
      }
      n = n->getnext();
   }

   n = _exptree->getfirstch( parent );
   while( n && lResult )
   {
      if( n->gettag() == ttOperator && !n->count() &&
          ( !strcmp( n->getText(), "+" ) || !strcmp( n->getText(), "-" ) )
        )
      {
         l = n->getprev();
         r = n->getnext();
         if( l && r )
         {
            l->moveto( n );
            r->moveto( n );
         }
      }
      n = n->getnext();
   }
   return lResult;
}
//---------------------------------------------------------------------------
bool atominter::evalNode( pnode* parent )
{
   bool lResult = true;
   bool lError;
   atom a;
   pnode* n;
   AnsiString p;
   int tag;
   int j;

   if( !parent )
   {
      n = _exptree->getfirst();
   }
   else
   {
      n = parent->getfirstch();
   }

   lError = false;
   while( n && !lError )
   {
      if( n->haschildren() )
      {
         if( evalNode( n ) )
         {
         }
         else
         {
            lError = true;
         }
      }

      if( !lError )
      {
         tag = n->gettag();
         p = AnsiString( n->getText() );
         switch( tag )
         {
            case ttOperator:
            Add2Log( "Processing operator [" + p + "]" );
            if( _stack->eval( p.c_str() ) )
            {
            }
            else
            {
               lError = true;
               _errorCode = 8;
               if( n->getdata() )
               {
                  _errorPos = *(int*)( n->getdata() );
               }
               else
               {
                  _errorPos = 0;
               }
               _errorExp = p;
            }
            break;

            case ttFunction:
            Add2Log( "Processing function [" + p + "]" );
            if( _stack->eval( p.c_str(), _casesens ) )
            {
            }
            else
            {
               lError = true;
               _errorCode = 7;
               if( n->getdata() )
               {
                  _errorPos = *(int*)( n->getdata() );
               }
               else
               {
                  _errorPos = 0;
               }
               _errorExp = p;
            }
            break;

            case ttInteger:
            a = atom( StrToDouble( p ) ); //p.ToInt() );
            Add2Log( "Pushing Integer as Double [" + AnsiString( a.getstring() ) + "]..." );
            _stack->push( a );
            break;

            case ttBinInteger:
            a = atom( BinStrToInt( p ), aifBin ); //p.ToInt() );
            Add2Log( "Pushing Binary, Integer as Double [" + AnsiString( a.getstring() ) + "]..." );
            _stack->push( a );
            break;

            case ttOctInteger:
            a = atom( OctStrToInt( p ), aifOct ); //p.ToInt() );
            Add2Log( "Pushing Octal Integer as Double [" + AnsiString( a.getstring() ) + "]..." );
            _stack->push( a );
            break;

            case ttHexInteger:
            a = atom( HexStrToInt( p ), aifHex ); //p.ToInt() );
            Add2Log( "Pushing Hex Integer as Double [" + AnsiString( a.getstring() ) + "]..." );
            _stack->push( a );
            break;

            case ttDouble:
            a = atom( StrToDouble( p ) );
            Add2Log( "Pushing Double Try=[" + p + "]; Get=[" + AnsiString( a.getstring() ) + "]..." );
            _stack->push( a );
            break;

            case ttExponent:
            a = atom( StrEToDouble( p.c_str() ) );
            Add2Log( "Pushing Exponent [" + AnsiString( a.getstring() ) + "]..." );
            _stack->push( a );
            break;

            case ttMeasure:
            a = atom( StrToMeasure( p ) ); //str2atom( p.c_str() )
            Add2Log( "Pushing Measure [" + AnsiString( a.getstring() ) + "]..." );
            _stack->push( a );
            break;

            case ttConstant:
            if( _const )
            {
               j = _const->findAtom( n->getText() );
               if( j != -1 )
               {
                  a = _const->getAtom( j );
                  Add2Log( "Pushing Constant of " + AnsiString( a.typestr() ) +
                           " [" + AnsiString( a.getstring() ) + "]..." );
                  _stack->push( a );
               }
               else
               {
                  _errorCode = 8;
               }
            }
            else
            {
               _errorCode = 8;
            }
            break;

            case ttVariable:
            if( _var )
            {
               j = _var->findAtom( n->getText() );
               if( j != -1 )
               {
                  a = _var->getAtom( j );
                  Add2Log( "Pushing Variable of " + AnsiString( a.typestr() ) +
                           " [" + AnsiString( a.getstring() ) + "]..." );
                  _stack->push( a );
               }
               else
               {
                  _errorCode = 9;
               }
            }
            else
            {
               _errorCode = 9;
            }
            break;

            case ttSymbol:
            a = str2atom( n->getText() );
            _stack->push( a );
            break;

            case ttSeparator:
            Add2Log( "Skipping Separator..." );
            break;

            case ttLParenth:
            case ttRParenth:
            case ttLBracket:
            case ttRBracket:
            case ttLCurly:
            case ttRCurly:
            break;

            default:
            _errorCode = 6;
            if( n->getdata() )
            {
               _errorPos = *(int*)( n->getdata() );
            }
            else
            {
               _errorPos = 0;
            }
            _errorExp = AnsiString( n->getText() );
            lError = true;
            break;
         }
         n = n->getnext();
      }
   }

   if( lError )
   {
      lResult = false;
   }
   return lResult;
}
//---------------------------------------------------------------------------
bool atominter::calcExp( void )
{
   bool lResult = false;

   _startms = 0;
   _stopms = 0;

   if( _stack && _exptree->countall() && !_errorCode )
   {
      lResult = evalNode( NULL );
      if( lResult && _stack->count() )
      {
         Add2Log( "Calculation OK!" );
         _result = _stack->get( 0 );
         Add2Log( "Result is [" + AnsiString( _result.getstring() ) + "]..." );
      }
      else //if( _errorCode )
      {
         #ifdef __BORLANDC__
         _errorStr = "Error code " + Sysutils::IntToStr( _errorCode ) +
                          " at pos." + Sysutils::IntToStr( _errorPos ) +
                          " in: ..." + _expstr.SubString( _errorPos, _expstr.Length() );
         #else
         _errorStr = "Error code " + IntToStr( _errorCode ) +
                          " at pos." + IntToStr( _errorPos ) +
                          " in: ..." + _expstr.SubString( _errorPos, _expstr.Length() );
         #endif
         Add2Log( _errorStr );
      }
   }
   return lResult;
}
//---------------------------------------------------------------------------
atom atominter::Result( void )
{
   return _result;
}
//---------------------------------------------------------------------------
void atominter::Add2Log( AnsiString Text, bool Clear )
{
   #ifdef __BORLANDC__
   if( MainForm )
   {
      if( Clear )
      {
         MainForm->Log->Lines->Clear();
      }
      MainForm->Log->Lines->Add( Text );
   }
	#else
	if( Text.Length() && Clear )
	{
	}
   #endif
   //fprintf( flog, "%s\n", Text.c_str() );
}
//---------------------------------------------------------------------------
void atominter::assignStack( atomstack* AStack )
{
   _stack = AStack;
}
//---------------------------------------------------------------------------
void atominter::assignConstants( atomlist* AConst )
{
   _const = AConst;
}
//---------------------------------------------------------------------------
void atominter::assignVariables( atomlist* AVar )
{
   _var = AVar;
}
//---------------------------------------------------------------------------
void atominter::setCaseSensitive( bool Enable )
{
   _casesens = Enable;
}
//---------------------------------------------------------------------------

