//---------------------------------------------------------------------------

#ifndef uUnitsH
#define uUnitsH

#include <astring.h>
#include <astrings.h>
//enum intKind { mukUnknown, mukLength, mukArea, mukMass, mukSpeed, mukTime };

//enum int { muAng, muMm, muCm, muInch, muFeet, muYard, muM, muKm, muMi, muNMi,
//                 muM2,
//                 muG, muLbm, muKg, muTon,
//                 muSec, muMin, muHour, muDay,
//                 muHa,
//                 muUnknown
//               };

#define UnitKindCount      8

const int
     ucLength        = 1,
     ucTime          = 2,
     ucSpeed         = 3,
     ucArea          = 4,
     ucVolume        = 5,
     ucMass          = 6,
     ucAcceleration  = 7,
     ucForce         = 8,
     ucEnergy        = 9,
     ucPower         = 10,
     ucPressure      = 11,
     ucTemperature   = 12,
     ucElCurr        = 13,
     ucAmtOfSubst    = 14,
     ucLuminous      = 15,
     ucRadiation     = 16,
     ucAngle         = 17,
     ucViscosity     = 18,

     ucUnknown       = 0xFFFF;

const int
     muAng          = 101,
     muNm           = 102,
     muMm           = 103,
     muCm           = 104,
     muInch         = 105,
     muDm           = 106,
     muFoot         = 107,
     muYard         = 108,
     muM            = 109,
     muFath         = 110,
     muRod          = 111,
     muChain        = 112,
     muFurlong      = 113,
     muKm           = 114,
     muMi           = 115,
     muNMi          = 116,
     muNMiUK        = 117,
     muAstroUnit    = 118,
     muLightYear    = 119,
     muParsec       = 120,

     muGrain        = 201,
     muG            = 202,
     muDram         = 203,
     muDwt          = 204,
     muOz           = 205,
     muOzTroy       = 206,
     muLbt          = 207,
     muLb           = 208,
     muKg           = 209,
     muStone        = 210,
     muCwt          = 211,
     muCwtUK        = 212,
     muTon          = 213,
     muTonUK        = 214,
     muTonUS        = 215,
     muCarat        = 216,
     muSlug         = 217,

     muSec          = 301,
     muMin          = 302,
     muHour         = 303,
     muDay          = 304,
     muWeek         = 305,
     muHz           = 306,

     muHa           = 401,
     muAre          = 402,
     muAcre         = 403,

     muL            = 501,
     muOunceFl      = 502,
     muOunceFlUK    = 503,
     muGal          = 504,
     muGalD         = 505,
     muGalUK        = 506,
     muQuart        = 507,
     muQuartD       = 508,
     muQuartUK      = 509,
     muPint         = 510,
     muPintD        = 511,
     muPintUK       = 512,
     muBushel       = 513,
     muBushelD      = 514,
     muBushelUK     = 515,
     muBarrel       = 516,
     muBarrelD      = 517,
     muBarrelUK     = 518,
     muBoardFoot    = 519,
     muPeck         = 520,
     muPeckUK       = 521,
     muStere        = 522,

     muAmper        = 601,

     muKelvin       = 701,
     muCelsius      = 702,
     muFahrenheit   = 703,
     muRankine      = 704,

     muMole         = 801,

     muCandela      = 901,

     muSteradian    = 951,

     muNewton       = 1001,
     muKNewton      = 1002,
     muDyn          = 1003,
     muLbf          = 1004,
     muPdl          = 1005,

     muJoule        = 1101,
     muKJoule       = 1102,
     muCal          = 1103,
     muKCal         = 1104,
     muEV           = 1105,
     muMEV          = 1106,
     muGEV          = 1107,
     muBTU          = 1108,
     muErg          = 1109,

     muWatt         = 1201,
     muKWatt        = 1202,
     muHorsePower   = 1203,
     muHorsePowerM  = 1204,

     muPascal       = 1301,
     muKPascal      = 1302,
     muAtm          = 1303,
     muPsi          = 1304,
     muPsf          = 1305,
     muMmHg         = 1306,
     muBar          = 1307,
     muMBar         = 1308,
     muInHg         = 1309,
     muTorr         = 1310,

     muKnot         = 1401,
     muMph          = 1402,
     muSpeedOfLight = 1403,

     muGravAcc      = 1501,

     muStilb        = 1601,

     muPhot         = 1701,
     muLux          = 1702,
     muFootCandle   = 1703,

     muFlam         = 1801,

     muVolt         = 2001,
     muWeber        = 2002,
     muTesla        = 2003,
     muSiemens      = 2004,
     muRoentgen     = 2005,
     muPoise        = 2006,
     muCoulomb      = 2007,
     muFarad        = 2008,
     muOhm          = 2009,
     muGray         = 2010,
     muHenry        = 2011,
     muFaraday      = 2012,

     muUnknown      = 9999;

//typedef int int;

typedef struct
{
   int unit;
   int count;
} TMeasureUnitEx;


class CUnit;
class CMeasure;

//---------------------------------------------------------------------------
CMeasure pow( CMeasure a, int power );
CMeasure sqrt( CMeasure a );
CMeasure inv( CMeasure a );
CMeasure xroot( CMeasure a, int power );

CMeasure ConvertTemperature( CMeasure SrcVal, CUnit To, bool ToSI = true );
CMeasure ConvertMeasure( CMeasure SrcVal, CUnit To, bool ToSI = true );
CMeasure round( CMeasure Src, int Precision );

bool ConsistentUnits( CMeasure a, CMeasure b );
   
CMeasure StrToMeasure( AnsiString Text );

AnsiString MeasureToStr( CMeasure a );
AnsiString MeasureToStrF( CMeasure a, int prec = -1 );
AnsiString MeasureToStrE( CMeasure a, int prec = -1 );
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
class CUnit
{
   private:

   public:
   TMeasureUnitEx* units;
   int Kind[ UnitKindCount ];
   int count;

   CUnit( void );
   CUnit( AnsiString AText );
   CUnit( const CUnit& AUnit );
   CUnit( CUnit* AUnit );
   ~CUnit();

   void AddUnit( AnsiString AText, int alo = 1 );
   void AddUnit( int AUnit, int alo = 1 );
   void DeleteUnit( int Index, int alo );

   bool ZeroKind( void );
   int UnitExists( int AUnit );
   void IncUnit( int AUnit, int alo = 1 );
   void IncUnit( AnsiString AUnit, int alo = 1 );
   void DecUnit( int AUnit, int alo = 1 );
   void DecUnit( AnsiString AUnit, int alo = 1 );

   bool Contains( CUnit AUnit );
   bool Contains2( CUnit AUnit );
   bool ContainsTemperature( void );

   void Append( CUnit AUnit );

   void Remove( CUnit AUnit );
   void Remove2( CUnit AUnit );

   CUnit Decompose( void );
   CUnit Compose( void );

   void Clear( void );
   CUnit Reverse( void ) const;

   bool BelongToSI( void );
   CUnit UnitToSI( void );

   bool AllowSqrt( void );
   bool AllowXRoot( int power );

   void FromString( AnsiString Text );

   const CUnit& operator=( const CUnit& val );

   AnsiString ToString( void );

   int GetSize( void );   
   int Save( FILE* f );
   int Load( FILE* f );

   friend CUnit operator*( CUnit& a, CUnit& b );
   friend CUnit operator/( CUnit& a, CUnit& b );

   friend bool operator==( CUnit a, CUnit b );
   friend bool operator!=( CUnit a, CUnit b );

   friend CUnit pow( CUnit& a, int power );
   friend CUnit sqrt( CUnit& a );
   friend CUnit xroot( CUnit a, int power );

   friend CUnit Decompose( CUnit AUnit );
   friend CUnit Compose( CUnit AUnit );
};
//---------------------------------------------------------------------------
CUnit StrToUnit( AnsiString Text );
CUnit JoinUnits( CUnit left, CUnit right );
CUnit Simplify( CUnit left, CUnit right );
bool CompareKind( CUnit left, CUnit right );
//---------------------------------------------------------------------------
class CMeasure
{
   private:
   int Kind;
   CUnit Unit;
   double Value;
   bool UseExpo;

   protected:

   public:
   CMeasure( void );
   CMeasure( double AValue, CUnit AUnit );
   CMeasure( double AValue, AnsiString AUnit );
   CMeasure( const CMeasure& AValue );

   ~CMeasure();

   double GetValue( void );
   CUnit GetUnit( void );

   const CMeasure& operator=( const CMeasure& val );

   AnsiString ToString( void );

   bool AllowSqrt( void );
   bool AllowXRoot( int power );

   bool BelongToSI( void );
   CMeasure ConvertToSI( void );
   CMeasure ConvertTo( CUnit AUnit );

   int GetSize( void );   
   int Save( FILE* f );
   int Load( FILE* f );

   friend CMeasure operator+( CMeasure a, CMeasure b );
   friend CMeasure operator-( CMeasure a, CMeasure b );

   friend CMeasure operator*( CMeasure a, CMeasure b );
   friend CMeasure operator*( double a, CMeasure b );
   friend CMeasure operator*( CMeasure a, double b );

   friend CMeasure operator/( CMeasure a, CMeasure b );
   friend CMeasure operator/( double a, CMeasure b );
   friend CMeasure operator/( CMeasure a, double b );

   friend CMeasure pow( CMeasure a, int power );
   friend CMeasure sqrt( CMeasure a );
   friend CMeasure inv( CMeasure a );
   friend CMeasure xroot( CMeasure a, int power );

   friend CMeasure ConvertTemperature( CMeasure SrcVal, CUnit To, bool ToSI );
   friend CMeasure ConvertMeasure( CMeasure SrcVal, CUnit To, bool ToSI );
   friend CMeasure round( CMeasure Src, int Precision );

   friend bool ConsistentUnits( CMeasure a, CMeasure b );
   
   friend CMeasure StrToMeasure( AnsiString Text );

   friend AnsiString MeasureToStr( CMeasure a );
   friend AnsiString MeasureToStrF( CMeasure a, int prec );
   friend AnsiString MeasureToStrE( CMeasure a, int prec );
};
//---------------------------------------------------------------------------
int GetUnitCount( void );
void SaveConversionTable( AnsiString FName );
//---------------------------------------------------------------------------
int GetMeasureCategories( TStrings* CatStr, TStrings* CatDsc );
int GetMeasuresInCategory( int Category, TStrings* MeasStr, TStrings* MeasDsc );
//---------------------------------------------------------------------------
#endif
