#ifdef __WIN32__
#include <windows.h>
#endif

#include <astrings.h>

const XString __empty__ = XString( "" );
//---------------------------------------------------------------------------------
TStrings::TStrings( void )
{
   FStrings = NULL;
   FCount = 0;
}
//---------------------------------------------------------------------------------
TStrings::~TStrings()
{
   Clear();
}
//---------------------------------------------------------------------------------
XString TStrings::Text( void )
{
   XString p = "";
   int j;
   
   for( j = 0; j < FCount; j++ )
   {
      p += ( *( FStrings[ j ] ) + XString( "\n" ) );
   }
   return p;
}
//---------------------------------------------------------------------------------
XString TStrings::operator[]( int Index ) const
{
   if( Index >= 0 && Index < FCount )
   {
      return *( FStrings[ Index ] );
   }
   else
   {
      return __empty__;
   }
}
//---------------------------------------------------------------------------------
void TStrings::Clear( void )
{
   if( FStrings && FCount )
   {
      int j;
      for( j = 0; j < FCount; j++ )
      {
         delete FStrings[ j ];
      }
      delete [] FStrings;
      FStrings = NULL;
      FCount = 0;
   }
}
//---------------------------------------------------------------------------------
void TStrings::Add( XString AString )
{
   XString** tmp;
   
   tmp = new XString*[ FCount + 1 ];
   if( FStrings && FCount )
   {
      int j;
      for( j = 0; j < FCount; j++ )
      {
         tmp[ j ] = FStrings[ j ];
      }
      delete [] FStrings;
   }
   tmp[ FCount ] = new XString( AString );
   FCount++;
   FStrings = tmp;
}
//---------------------------------------------------------------------------------
void TStrings::AddStrings( TStrings* AStrings )
{
   if( AStrings )
   {
      int j;
      
      for( j = 0; j < AStrings->Count(); j++ )
      {
         Add( AStrings->String( j ) );
      }
   }
}
//---------------------------------------------------------------------------------
void TStrings::Insert( int nIndex, XString AString )
{
   if( FStrings && FCount && nIndex >= 0 && nIndex < FCount )
   {
      XString** tmp;
      XString msg;
      int j, i;
      
      tmp = new XString*[ FCount + 1 ];
      for( j = 0, i = 0; j < FCount; j++ )
      {
         if( j == nIndex )
         {
            i++;
         }
         //msg = *( FStrings[ j ] ) + ";j=" + IntToStr( j ) + ";i=" + IntToStr( i );
         //MessageBox( 0, msg.c_str(), "Inserting...", MB_OK );
         tmp[ j + i ] = FStrings[ j ];
      }
      delete [] FStrings;
      tmp[ nIndex ] = new XString( AString );
      FCount++;
      FStrings = tmp;
   }
   else
   {
      Add( AString );
   }
}
//---------------------------------------------------------------------------------
void TStrings::Delete( int nIndex )
{
   if( FStrings && FCount && nIndex >= 0 && nIndex < FCount )
   {
      if( FCount == 1 && nIndex == 0 )
      {
         Clear();
      }
      else
      {
         XString** tmp;
         int i, j;
         
         tmp = new XString*[ FCount - 1 ];
         for( j = 0, i = 0; j < FCount; j++ )
         {
            if( j != nIndex )
            {
               tmp[ i ] = FStrings[ j ];
               i++;
            }
         }
         delete FStrings[ nIndex ];
         delete [] FStrings;
         
         FCount--;
         FStrings = tmp;
      }
   }
}
//---------------------------------------------------------------------------------
XString TStrings::String( int nIndex )
{
   XString p = "";
   if( FStrings && FCount && nIndex >= 0 && nIndex < FCount )
   {
      p = *( FStrings[ nIndex ] );
   }
   return p;
}
//---------------------------------------------------------------------------------
void TStrings::Replace( int nIndex, XString Value )
{
   if( FStrings && FCount && nIndex >= 0 && nIndex < FCount )
   {
      *( FStrings[ nIndex ] ) = Value;
   }
}
//---------------------------------------------------------------------------------
int TStrings::Count( void )
{
   return FCount;
}
//---------------------------------------------------------------------------------
int TStrings::IndexOf( XString AString )
{
   int j, index = -1;
   
   if( FStrings && FCount )
   {
      for( j = 0; j < FCount && index == -1; j++ )
      {
         if( *( FStrings[ j ] ) == AString )
         {
            index = j;
         }
      }
   }
   return index;
}
//---------------------------------------------------------------------------------

