#ifndef _ATOM_H
#define _ATOM_H

#include <stdio.h>
#include <acomplex.h>
#include <avector.h>
#include <amatrix.h>
#include <ameasure.h>

//-----------------------------------------------------------------------------
const int
   aInteger      = 0x01,
   aBoolean      = 0x02,
   aDouble       = 0x03,
   aExponent     = 0x04,
   aMeasure      = 0x05,
   aComplex      = 0x06,
   aVector       = 0x07,
   aMatrix       = 0x08,
   
   aString       = 0x10,
   aExpression   = 0x11,

   aSymbol       = 0x20,

   aList         = 0x30,
   
   aUnknown      = 0x00;
   
const unsigned char
   aifUnknown     = 0x00,
   aifDec         = 0x01,
   aifHex         = 0x02,
   aifOct         = 0x03,
   aifBin         = 0x04,
   aifExp         = 0x05;
   
class atom;
//class aint;
//class abool;
//class adouble;
//class acomplex;

//-----------------------------------------------------------------------------
extern atom NULLA;
extern atom nullatom;
extern atom ZeroAtom;

//-----------------------------------------------------------------------------
atom sin( atom& a );
atom sinh( atom& a );
atom asin( atom& a );
atom asinh( atom& a );
   
atom cos( atom& a );
atom cosh( atom& a );
atom acos( atom& a );
atom acosh( atom& a );
   
atom tan( atom& a );
atom tanh( atom& a );
atom atan( atom& a );
atom atanh( atom& a );
   
atom cot( atom& a );
atom coth( atom& a );
atom acot( atom& a );
atom acoth( atom& a );
   
atom sec( atom& a );
atom sech( atom& a );
atom asec( atom& a );
atom asech( atom& a );

atom csc( atom& a );
atom csch( atom& a );
atom acsc( atom& a );
atom acsch( atom& a );
   
atom deg2rad( atom& a );
atom rad2deg( atom& a );
   
atom exp( atom& a );
atom abs( atom& a );
atom sign( atom& a );
atom log( atom& a );
atom log10( atom& a );
atom sqrt( atom& a );
atom expm( atom& a );
atom lnp1( atom& a );
atom factorial( atom& a );
atom real2exponent( atom& a );
atom exponent2real( atom& a );
   
atom pow( atom& a, atom& b );
atom rootn( atom& a, atom& b );

atom real2complex( atom& a, atom& b );
atom real( atom& a );
atom imag( atom& a );
atom arg( atom& a );
atom conj( atom& a );
atom polar( atom& a, atom& b );
atom norm( atom& a );
atom round( atom& a, int prec );
   
atom atom_ip( atom& a );
atom atom_fp( atom& a );
   
atom equal( atom& a, atom& b );
atom great( atom& a, atom& b );
atom less( atom& a, atom& b );
   
atom uomconvert( atom& a, atom& b );
   
atom cross( atom& a, atom& b );
atom dot( atom& a, atom& b );
atom length( atom& a );
atom real2vector2( atom& a, atom& b );
atom real2vector3( atom& a, atom& b, atom& c );

atom int2bin( atom& a );
atom int2oct( atom& a );
atom int2dec( atom& a );
atom int2hex( atom& a );

atom num2exp( atom& a );
atom exp2num( atom& a );
   
atom aand( atom& a, atom& b );
atom aor( atom& a, atom& b );
atom axor( atom& a, atom& b );
atom anot( atom& a );
atom adiv( atom& a, atom& b );
atom amod( atom& a, atom& b );
atom aslb( atom& a );
atom asrb( atom& a );
atom arlb( atom& a );
atom arrb( atom& a );

atom percent( atom& a, atom& b );
atom percentt( atom& a, atom& b );
atom percentch( atom& a, atom& b );

atom isprime( atom& a );
atom gamma( atom& a );
atom psi( atom& a );
   
atom fv( atom& N, atom& I, atom& PV, atom& PMT = NULLA ); //0.0, atom& M = 0.0, atom& G = 0.0 );
atom pmt( atom& N, atom& I, atom& PV, atom& FV = NULLA ); //, atom& M = 0.0, atom& G = 0.0 );
atom pv( atom& N, atom& I, atom& FV, atom& PMT = NULLA ); //0.0, atom& M = 0.0, atom& G = 0.0 );
   
atom str2atom( const char* text );
   
atom mix_2_atoms_with_opr( atom& a, atom& b, const char* opr );
atom mix_1_atom_with_func( atom& a, const char* func );
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
class atom 
{
   private:
   char* strbuf;
   AnsiString astrbuf;
   
   void makestrbuf( char* buf );
   void clear( void );
   
   protected:
   int _type;
   unsigned char _format;
   void* _value;
   char* _name;
   bool _valid;
   
   public:
   //atom( int ntype ) { _type = ntype; value = NULL; };
   atom( void );
   atom( int avalue, unsigned char aformat = aifDec );
   atom( bool avalue );
   atom( double avalue, unsigned char aformat = aifDec );
   atom( double are, double aim, unsigned char aformat = aifDec );
   atom( CComplex c, unsigned char aformat = aifDec );
   atom( CVector v );
   atom( CMatrix m );
   atom( CMeasure m, unsigned char aformat = aifDec );
   atom( const char* str );
   atom( const atom& a );
   atom( const atom& a, const char* name );
   atom( const atom& a, bool valid );

   virtual ~atom(); // Destructor

   virtual void release( void );
   virtual bool save( FILE* f );
   virtual bool load( FILE* f );

   const atom& operator=( const atom& a );

   operator int();
   operator bool();
   operator double();
	//double toDouble();
   operator CComplex();
   atom operator!( void );

   /*
   operator aint();
   operator abool();
   operator adouble();
   operator acomplex();
   */

   bool isvalid( void );
   bool isnull( void ) { return _value == NULL; }
   bool isint( void ) { return _type == aInteger; }
   bool isbool( void ) { return _type == aBoolean; }
   bool isdouble( void ) { return _type == aDouble; }
   bool isexp( void ) { return _type == aExponent; }
   bool iscomplex( void ) { return _type == aComplex; }
   bool isvector( void ) { return _type == aVector; }
   bool ismatrix( void ) { return _type == aMatrix; }
   bool isstring( void ) { return _type == aString; }
   bool isexpr( void ) { return _type == aExpression; }

   bool isnumeric( void ) { return ( _type == aInteger ||
                                     _type == aDouble ||
                                     _type == aComplex || 
                                     _type == aBoolean ); }
   
   bool iscompatible( atom& a );
   
   friend bool issame( atom& a, atom&b ) { return a._type==b._type; }
   int type( void ) const { return _type; }
   unsigned char format( void ) const { return _format; }
   int atomsize( void ) const;
   
   const char* typestr( void );
   const char* getstring( int prec = -1 ); // return string buffer strbuf
   const char* getnamed( int prec = -1 ); // return string buffer strbuf
   
   void setname( const char* aname );
   void setformat( unsigned char aformat = aifDec );
   
   const char* name( void );
   const void* value( void ) { return _value; }
   
   bool valid( void ) const { return _valid; }
   
   friend atom operator+( atom& a, atom& b );
   friend atom operator-( atom& a, atom& b );
   friend atom operator*( atom& a, atom& b );
   friend atom operator/( atom& a, atom& b );
   friend atom operator==( atom&a, atom& b );
   friend atom operator!=( atom&a, atom& b );
   friend atom operator>( atom&a, atom& b );
   friend atom operator>=( atom&a, atom& b );
   friend atom operator<( atom&a, atom& b );
   friend atom operator<=( atom&a, atom& b );  
   
   friend atom sin( atom& a );
   friend atom sinh( atom& a );
   friend atom asin( atom& a );
   friend atom asinh( atom& a );
   
   friend atom cos( atom& a );
   friend atom cosh( atom& a );
   friend atom acos( atom& a );
   friend atom acosh( atom& a );
   
   friend atom tan( atom& a );
   friend atom tanh( atom& a );
   friend atom atan( atom& a );
   friend atom atanh( atom& a );
   
   friend atom cot( atom& a );
   friend atom coth( atom& a );
   friend atom acot( atom& a );
   friend atom acoth( atom& a );
   
   friend atom sec( atom& a );
   friend atom sech( atom& a );
   friend atom asec( atom& a );
   friend atom asech( atom& a );

   friend atom csc( atom& a );
   friend atom csch( atom& a );
   friend atom acsc( atom& a );
   friend atom acsch( atom& a );
   
   friend atom deg2rad( atom& a );
   friend atom rad2deg( atom& a );
   
   friend atom exp( atom& a );
   friend atom abs( atom& a );
   friend atom sign( atom& a );
   friend atom log( atom& a );
   friend atom log10( atom& a );
   friend atom sqrt( atom& a );
   friend atom expm( atom& a );
   friend atom lnp1( atom& a );
   friend atom factorial( atom& a );
   friend atom real2exponent( atom& a );
   friend atom exponent2real( atom& a );
   
   friend atom pow( atom& a, atom& b );
   friend atom rootn( atom& a, atom& b );

   friend atom real2complex( atom& a, atom& b );
   friend atom real( atom& a );
   friend atom imag( atom& a );
   friend atom arg( atom& a );
   friend atom conj( atom& a );
   friend atom polar( atom& a, atom& b );
   friend atom norm( atom& a );
   friend atom round( atom& a, int prec );
   
   friend atom atom_ip( atom& a );
   friend atom atom_fp( atom& a );
   
   friend atom equal( atom& a, atom& b );
   friend atom great( atom& a, atom& b );
   friend atom less( atom& a, atom& b );
   
   friend atom uomconvert( atom& a, atom& b );
   
   friend atom cross( atom& a, atom& b );
   friend atom dot( atom& a, atom& b );
   friend atom length( atom& a );
   friend atom real2vector2( atom& a, atom& b );
   friend atom real2vector3( atom& a, atom& b, atom& c );

   friend atom int2bin( atom& a );
   friend atom int2oct( atom& a );
   friend atom int2dec( atom& a );
   friend atom int2hex( atom& a );
   
   friend atom aand( atom& a, atom& b );
   friend atom aor( atom& a, atom& b );
   friend atom axor( atom& a, atom& b );
   friend atom anot( atom& a );
   friend atom adiv( atom& a, atom& b );
   friend atom amod( atom& a, atom& b );
   friend atom aslb( atom& a );
   friend atom asrb( atom& a );
   friend atom arlb( atom& a );
   friend atom arrb( atom& a );

   friend atom percent( atom& a, atom& b );
   friend atom percentt( atom& a, atom& b );
   friend atom percentch( atom& a, atom& b );

   friend atom isprime( atom& a );
   friend atom gamma( atom& a );
   friend atom psi( atom& a );
   
   friend atom fv( atom& N, atom& I, atom& PV, atom& PMT ); //0.0, atom& M = 0.0, atom& G = 0.0 );
   friend atom pmt( atom& N, atom& I, atom& PV, atom& FV ); //, atom& M = 0.0, atom& G = 0.0 );
   friend atom pv( atom& N, atom& I, atom& FV, atom& PMT ); //0.0, atom& M = 0.0, atom& G = 0.0 );
   
   friend atom str2atom( const char* text );
   
   friend atom mix_2_atoms_with_opr( atom& a, atom& b, const char* opr );
   friend atom mix_1_atom_with_func( atom& a, const char* func );
};
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/*
class aint : public atom
{
   protected:
   int value;
   
   public:
   aint( void );
   aint( int avalue );
   aint( const aint& a );

   virtual void release( void );
};
//-----------------------------------------------------------------------------
class abool : public atom
{
   protected:
   bool value;
   
   public:
   abool( void );
   abool( bool avalue );
   abool( const abool& a );

   virtual void release( void );
};
//-----------------------------------------------------------------------------
class adouble : public atom
{
   protected:
   double value;
   
   public:
   adouble( void );
   adouble( double avalue );
   adouble( const adouble& a );

   virtual void release( void );
};
//-----------------------------------------------------------------------------
class acomplex : public atom
{
   protected:
   double re, im;
   
   public:
   acomplex( void );
   acomplex( double are, double aim );
   acomplex( const acomplex& a );
   
   virtual void release( void );

   double getre( void );
   double getim( void );
};
*/
//-----------------------------------------------------------------------------
#endif // _ATOM_H
