//---------------------------------------------------------------------------
#ifndef aVectorH
#define aVectorH

#include <astring.h>
#include <astrings.h>
#include <acomplex.h>

//namespace Vectors
//{
//---------------------------------------------------------------------------
class CVector;

CVector cross( const CVector& a, const CVector& b );
   //friend long double cross2( const CVector& a, const CVector& b );
CComplex dot( const CVector& a, const CVector& b );
CVector round( const CVector& a, int ARound );

AnsiString VectorToStr( const CVector& v );
AnsiString VectorToStrF( const CVector& v, int prec = -1 );
CVector StrToVector( AnsiString t );

//---------------------------------------------------------------------------
class CVector
{
   private:
   int FSize;
   CComplex* Values;
   //long double* Values;

   public:
   CVector( void );
   CVector( double* values, int size );
   CVector( CComplex* values, int size );
   CVector( const CVector& Var );
   CVector( CVector* Var );
   ~CVector();

   int GetSize( void ) const;
   int SetSize( int ASize );
   //CComplex Length( void ) const;
   double Length( void ) const;
   AnsiString ToString( int prec = -1 ) const;

   int Save( FILE* f );
   int Load( FILE* f );
   
   CComplex GetValue( int Index ) const;
   //long double GetValue( int Index ) const;

   void SetValue( int Index, CComplex Value );
   //CComplex& operator[]( const int& index );
   CComplex& operator[]( const int& index );
   //reference operator[] (size_type n);

   CComplex* operator* () const { return NULL; }

   const CVector& operator=( const CVector& val );

   const CVector& operator-=( const CVector& val );
   const CVector& operator+=( const CVector& val );

   //long double operator*=( const CVector& val );
   const CVector& operator*=( const CComplex& val );
   //const CVector& operator*=( const long double& val );

   //const CVector& operator/=( const CVector& val );
   const CVector& operator/=( const CComplex& val );
   //const CVector& operator/=( const long double& val );

   //long double abs( void );
   //long double norm( void );
   //void conj( void );
   friend CVector operator+( const CVector& a, const CVector& b );
   friend CVector operator-( const CVector& a, const CVector& b );

   //friend long double operator*( const CVector& a, const CVector& b );

   friend CVector operator*( const CVector& a, const CComplex& b );
   friend CVector operator*( const CComplex& a, const CVector& b );

   //friend long double operator/( const CVector& a, const CVector& b );
   friend CVector operator/( const CVector& a, const CComplex& b );
   //friend CVector operator/( const long double& a, const CVector& b );
   //friend CVector operator^( const CVector& a, const CVector& b );
   //friend CVector operator^( const long double& a, const CVector& b );
   //friend CVector operator^( const CVector& a, const long double& b );

   friend bool operator==( const CVector& a, const CVector& b );
   friend bool operator!=( const CVector& a, const CVector& b );
   friend bool operator<=( const CVector& a, const CVector& b );
   friend bool operator>=( const CVector& a, const CVector& b );
   friend bool operator<( const CVector& a, const CVector& b );
   friend bool operator>( const CVector& a, const CVector& b );

   friend CVector cross( const CVector& a, const CVector& b );
   //friend long double cross2( const CVector& a, const CVector& b );
   friend CComplex dot( const CVector& a, const CVector& b );
   friend CVector round( const CVector& a, int ARound );

   friend AnsiString VectorToStr( const CVector& v );
   friend AnsiString VectorToStrF( const CVector& v, int prec );
   friend CVector StrToVector( AnsiString t );
};
//---------------------------------------------------------------------------
//};
#endif
