#ifndef _CALCTYPES_H
#define _CALCTYPES_H

//---------------------------------------------------------------------------
enum TCalcOperation { oprNone, oprExec, oprClear, oprAdd, oprSub, oprMul, oprDiv,
                      oprPerc, 
                      oprSignChng, opr1perX, oprSqrt,
                      oprXRoot, oprXpow2, oprYpowX,
                      oprLog, oprLn, oprExp, oprALog,
                      oprSin, oprCos, oprTan, oprCTan,
                      oprASin, oprACos, oprATan, oprACTan,
                      oprSinH, oprCosH, oprTanH, oprCTanH,
                      oprArgSH, oprArgCH, oprArgTH,
                      oprSec, oprCosec,
                      oprSecH, oprCosecH,
                      oprConj, oprNorm, oprArg, oprInv, oprAbs,
                      oprSum, oprAvg,
                      oprEq, oprNEq, oprLess, oprLessEq, oprGreat, oprGreatEq,
                      opr2Hex, opr2Bin, opr2Oct,
                      oprUnknown
                    };

//enum TCalcKeyMode { tcmStd, tcmPrimary, tcmSecondary, tcmAlpha };
typedef int TCalcKeyMode;
const int
   tcmStd        = 0x0001,
   tcmPrimary    = 0x0002,
   tcmSecondary  = 0x0004,
   tcmAlpha      = 0x0008;

enum TCalcBaseMode { tcmDecimal, tcmBinary, tcmOctal, tcmHexadecimal };

typedef struct //TRect
{
   int Left;
   int Top;
   int Right;
   int Bottom;
} TRect;

enum TCalcDispMode { tcmClear, tcmRPN, tcmHistory, tcmAlgebraic, tcmObject, tcmStandard };
/*
AnsiString ButtonDesc[] = {
                          "btn0", "btn1", "btn2", "btn3",
                          "btn4", "btn5", "btn6", "btn7",
                          "btn8", "btn9", "btnDot", "btnPlusMinus", "btnX",
                          "btnAdd", "btnSub", "btnMul", "btnDiv",
                          "btnEnter", "btnBackSpace", "btnClear", "btnClose",
                          "btn1/X", "btnSqrt", "btnSin", "btnCos", "btnTan",
                          "btnY^X", "btnEEX", "btnSpace",
                          "btnHist", "btnCat", "btnEqw", "btnSymb",
                          "btnApps", "btnMode", "btnTool",
                          "btnVar", "btnSto", "btnNxt",
                          "btnUp", "btnDown", "btnLeft", "btnRight",
                          "btnF1", "btnF2", "btnF3", "btnF4", "btnF5", "btnF6",
                          "btnAlpha", "btnMode1", "btnMode2",
                          "?"
                          };
*/
enum TButtonAction {
                    baUnknown,
                    ba0, ba1, ba2, ba3,
                    ba4, ba5, ba6, ba7,
                    ba8, ba9,
                    baA, baB, baC, baD, baE, baF, baG, baH,
                    baI, baJ, baK, baL, baM, baN, baO, baP,
                    baQ, baR, baS, baT, baU, baV, baW, baX,
                    baY, baZ,
                    baDot, baNeg, baSign,
                    baAdd, baSub, baMul, baDiv,
                    baArg, baPolar, baConj, baNorm, baInv,
                    baSum, baProd, baAvg, baMin, baMax,
                    baEnter, baBackSpace, baDel, baClear, baClose, 
                    ba1perX, baSqrt, baXRoot,
                    baLog, baLn, baLnp1, baExp, baExpm, baALog, baAbs,
                    baSin, baCos, baTan, baCtg,
                    baASin, baACos, baATan, baACtg,
                    baSinH, baCosH, baTanH, baCtgH,
                    baArgSH, baArgCH, baArgTH, baArgCTH,
                    baSec, baASec, baSecH, baASecH,
                    baCsc, baACsc, baCscH, baACscH,
                    baYpowX, baEex, baSpace,
                    baHist, baCmd, baCat, baEqw, baSymb,
                    baApps, baMode, baTool,
                    baVar, baSto, baNxt,
                    baUp, baDown, baLeft, baRight,
                    baHome, baEnd, baTop, baBottom,
                    baF1, baF2, baF3, baF4, baF5, baF6,
                    baAlpha, baMode1, baMode2,
                    baXpow2,
                    baAns,
                    baRoLBrace, baRoRBrace, baRndBracket,
                    baSqLBrace, baSqRBrace, baSqrBracket,
                    baAbsBrace, baAbsBracket,
                    baKlamry, baQuotas, baExpression, baUnderscore,
                    baEq, baNEq, baLess, baLessEq, baGreat, baGreatEq,
                    baAnd, baOr, baXor, baNot, baIntDiv, baIntMod,
                    baSlb, baSrb, baRlb, baRrb,
                    baDeriv, baDervx, baInteg, baIntvx, baIntegN,
                    baSolve, baSolvx,
                    baDefVar, baDelVar, baDefAssign,
                    baDotVector, baCrossVector, baLength,
                    baReal2Vector2, baReal2Vector3,
                    baPi, baReal2Complex, baComplexI, baRe, baIm, baFp, baIp,
                    baHash, ba2Hex, ba2Oct, ba2Bin, ba2Dec,
                    baSetRad, baSetDeg, baSetPrecision, 
                    baAlgebraMode, baRPNMode,
                    baDeg2Rad, baRad2Deg, baDeg, baRad, baDegRad,
                    baConvert, baConstants, baVariables, baFinance, 
                    baUnitConverter,
                    baUnitsMenu,
                    baMathMenu, baTrigMenu, baHyperMenu, baBaseMenu, baRealMenu,
                    baComplexMenu, baVectorMenu, baBitsMenu, baLogicMenu,
                    baCalcMenu, baAlgMenu, baDerivIntegMenu, baSolveMenu,
                    baConfigMenu, baModeMenu, baAngleMeasure, 
                    baOk, baCancel, baYes, baNo, 
                    baEval, baNum, baEdit, baMinimize, baSeparator, baSet,
                    baPercent, baPercentT, baPercentCH,
                    baFactorial, baIsPrime, baGamma, baPsi,
                    baEcho, baDrop, baCopy, baPaste, baUndo, baSwap, ba2Top,
                    baPlot,
                    baInfo,
                    baUser, baEntry,
                    baZoomIn, baZoomOut,
                    baUnknownEnd
                   };
//---------------------------------------------------------------------------
typedef struct
{
   TButtonAction command;
   //char caption[ 20 ];
   const char* caption;
} TCmdMenuItem;
//---------------------------------------------------------------------------
typedef struct
{
   char name[ 30 ];
   TButtonAction action;
   char hint[ 100 ];
}
btnDesc;
//---------------------------------------------------------------------------
extern const TCmdMenuItem CmdMenuItems[];
extern const btnDesc BtnDesc[];
//---------------------------------------------------------------------------

#endif // _CALCTYPES_H

