
#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>

#include "pgcalc.h"

static const char *description =
	I18N_NOOP("PG Calculator");
// INSERT A DESCRIPTION FOR YOUR APPLICATION HERE
	
	
static KCmdLineOptions options[] =
{
  { "s", 0, 0 },
  { "skinname <name>", I18N_NOOP( "Set skin name used by PG Calculator" ), "default" },
  { "t", 0, 0 },
  { "tray", I18N_NOOP( "Run PG Calculator in System Tray" ), 0 },
  { 0, 0, 0 }
  // INSERT YOUR COMMANDLINE OPTIONS HERE
};

int main(int argc, char *argv[])
{
   int result;
  KAboutData aboutData( "PG Calculator", I18N_NOOP("PGCalculator"),
    VERSION, description, KAboutData::License_GPL,
    "(c) 2001-2004, Piotr Gridniew", 0, 0, "gridniew@pgcalc.net");
  aboutData.addAuthor("Piotr Gridniew",0, "gridniew@pgcalc.net");
  KCmdLineArgs::init( argc, argv, &aboutData );
  KCmdLineArgs::addCmdLineOptions( options ); // Add our own options.
  KApplication a;
  //QApplication a( argc, argv );

  KCmdLineArgs* args = KCmdLineArgs::parsedArgs();
  SkinName = args->getOption( "skinname" );
  
  //App = new KApplication();
  Calc = new TCalc( 0, "PGCalc" );
  a.setMainWidget(Calc);
  Calc->LoadState();
  if( args->isSet( "tray" ) )
  {
      Calc->hideToSysTray();
  }
  else
  {
     Calc->show();
  }
  //fprintf( stderr, "KDE Dir is (%s)...\n", (const char*)( kapp->kde_appsdir() ) );
  result = a.exec();
  //delete App;

  return result;
}
