
#ifndef PGCALC_H
#define PGCALC_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapp.h>
#include <qwidget.h>
#include <qlabel.h>
#include <qpixmap.h>
#include <qimage.h>
#include <qmessagebox.h>
//#include "qapplication.h"
#include <kconfig.h>

#include "tlcd.h"
#include "tcalcbutton.h"
#include "tpgsystemtray.h"
#include "ucalcobj.h"
#include "uCalcRPN.h"
#include "uCalcAlg.h"
#include "uCalcConst.h"
#include "uCalcVar.h"
#include "uCalcTVM.h"
#include "uCalcUnitConv.h"
#include "astack.h"
#include "ainter.h"
//-----------------------------------------------------------------------------------------------
const int
   cbmNone      = 0x00,
   cbmMode1     = 0x01,
   cbmMode2     = 0x02,
   cbmAlpha     = 0x04;
//-----------------------------------------------------------------------------------------------
/** PGCalc is the base class of the project */
class TCalc : public QWidget
{
  Q_OBJECT 
  public:
    /** construtor */
    TCalc(QWidget* parent=0, const char *name=0);
    /** destructor */
    ~TCalc();

  atomlist* CreateConstants( void );
  atomlist* CreateVariables( void );
  
  QImage image( void ) { return img; }
  TLCDDisplay* GetLCD( void ) { return LCD; }
  TCalcObject* activeObject( void ) { return ActiveObject; }
  bool Terminated( void ) { return FTerminated; }

  void setActiveObject( TCalcObject* obj );
  void LoadSkin( QString ASkinName );
  void ExecAction( TButtonAction& Action );
  TButtonAction getButtonAction( TCalcButton* Button );
  TCalcButton* GetButtonByAction( TButtonAction Action );
  void showButtonModes( void );
  void hideToSysTray( void );
  
  void CmdCatalog( void );
  void SetMode( TButtonAction Action );
  void ConstLibDialog( void );
  void VarListDialog( void );
  void TVMDialog( void );
  void UnitConverter( void );
  
  void ConfigMenu( void );
  void ModeMenu( void );
  
  void SetPrecision( void );
  void AngleMeasureMenu( void );
  
  void AppsMenu( void );
  void MathMenu( void );
  void RealFuncMenu( void );
  void BaseFuncMenu( void );
  void BitsFuncMenu( void );
  void LogicFuncMenu( void );
  void ComplexFuncMenu( void );
  void VectorFuncMenu( void );
  void CalcFuncMenu( void );
  void DerivIntegFuncMenu( void );
  void AlgFuncMenu( void );
  void SolveFuncMenu( void );
  void TrigFuncMenu( void );
  void HyperFuncMenu( void );
  int UOMCategory( void );
  int UOMUnits( int Category, AnsiString Description );

  void AllowMenu( void ) { FMenuAllowed = true; }
  void DisallowMenu( void ) { FMenuAllowed = false; }
  bool MenuAllowed( void ) { return FMenuAllowed; }
  int Precision( void ) { return FPrec; }

  bool LoadDefaults( void );
  bool LoadState( void );
  bool SaveState( void );

  atomstack* Stack;
  atominter* Inter;
  TStringList* History;
  atomlist* Constants;
  atomlist* Variables;
  
  TCalcRPN* RPN;
  TCalcAlg* Alg;
  TCalcConstLib* ConstLib;
  TCalcVarList* VarList;
  TCalcTVM* TVM;
  TCalcUnitConv* UnitConv;
  
  protected:
  virtual void paintEvent( QPaintEvent* e );
  virtual void mousePressEvent( QMouseEvent* e );
  virtual void mouseReleaseEvent( QMouseEvent* e );
  virtual void mouseMoveEvent( QMouseEvent* e );
  virtual void keyPressEvent( QKeyEvent* e );
  virtual void keyReleaseEvent( QKeyEvent* e );
  virtual void showEvent( QShowEvent* e );
  
  private:
  QImage img;
  QPixmap bkgr;
  QLabel* lbl;

  int mx, my;
  int ml, mt;
  ButtonState mbutton;
  bool mpressed;

  TPGSystemTray* SysTray;
  TLCDDisplay* LCD;
  TCalcButtonList* Buttons;
  TCalcButton* CurrentButton;
  TCalcObject* ActiveObject;
  bool FTerminated;
  bool FStayOnTop;
  bool FMenuAllowed;
  int FLastCommand;
  int FPrec;
  int ButtonMode;

  QRgb str2rgb( const char* str );
};

extern KApplication* App;
extern TCalc* Calc;
extern QString MainPath;
extern QString SkinPath;
extern QString SkinName;
#endif
