//---------------------------------------------------------------------------

#ifndef ptreeH
#define ptreeH

#include <stdio.h>

//---------------------------------------------------------------------------
struct dataptr
{
   int size;
   void* ptr;
   dataptr()
   {
      size = 0;
      ptr = NULL;
   }
};
//---------------------------------------------------------------------------
class ptree;
class pnode;
//---------------------------------------------------------------------------
class pnode
{
   friend class ptree;

   protected:
   int level;
   int tag;
   char* text;
   pnode* next;
   pnode* prev;
   pnode* nodes;
   pnode* parent;
   ptree* owner;
   dataptr data;

   public:
   pnode( const char* atext = NULL );
   virtual ~pnode();

   void setlevel( int alevel );

   void settag( int atag );
   int gettag( void );

   void setText( const char* atext );
   char* getText( void ) const; // { return text; }

   virtual void setdata( int asize, void* adata );
   virtual void* getdata( void );
   virtual int getdatasize( void );
   virtual void cleardata( void );

   virtual void clear( void );
   virtual void printf( int alevel = 0 );

   bool haschildren( void );
   int count( void );
   int countall( void );

   void addchild( pnode* anode );
   void delchild( pnode* anode );

   void copyto( pnode* anode );
   void moveto( pnode* anode );

   pnode* getparent( void );
   ptree* getowner( void );
   
   pnode* getfirst( void );
   pnode* getlast( void );
   pnode* getnext( void );
   pnode* getprev( void );

   pnode* getfirstch( void );
   pnode* getlastch( void );
   pnode* getnextch( pnode* node );
   pnode* getprevch( pnode* node );

   virtual int savetofile( FILE* f );
   virtual int loadfromfile( FILE* f );
};
//---------------------------------------------------------------------------
class ptree
{
   friend class pnode;

   private:
   pnode* root;
   pnode* nodes;

   public:
   ptree( void );
   virtual ~ptree();

   virtual void clear( void );
   virtual void printf( void );
   int count( void );
   int countall( void );

   void addnode( pnode* anode, pnode* parent = NULL );
   void addnode( char* atext, pnode* parent = NULL );
   void insert_node_after( pnode* anode, pnode* node_above );
   void insert_node_before( pnode* anode, pnode* node_below );
   void delnode( pnode* anode );

   pnode* getfirst( void );
   pnode* getlast( void );
   pnode* getnext( pnode* node );
   pnode* getprev( pnode* node );

   pnode* getfirstch( pnode* node );
   pnode* getlastch( pnode* node );
   pnode* getnextch( pnode* parent, pnode* node );
   pnode* getprevch( pnode* parent, pnode* node );

   void moveto( pnode* src, pnode* dst );

   virtual int savetofile( FILE* f );
   virtual int savetofile( const char* fname );
   virtual int loadfromfile( FILE* f );
   virtual int loadfromfile( const char* fname );
   virtual pnode* search( const char* text, pnode* node = NULL );
};
//---------------------------------------------------------------------------
#endif
