/***************************************************************************
                          tcalcbutton.cpp  -  description
                             -------------------
    begin                : ?ro lis 6 2002
    copyright            : (C) 2002 by Piotr Gridniew
    email                : gridniew@x4.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "qpainter.h"

#include "pgcalc.h"
#include "tcalcbutton.h"
#include "keycodetr.h"

//----------------------------------------------------------------------------
//
//
//
//----------------------------------------------------------------------------
TCalcButton::TCalcButton( TCalc* Owner )
{
   _owner = Owner;
   _left = 0;
   _top = 0;
   _width = 0;
   _height = 0;
	_kind = 0;
	_key = 0;
	_chr = 0;
	_action = baUnknown;
	_mode1action = baUnknown;
	_mode2action = baUnknown;
	_alphaaction = baUnknown;
   _name = NULL;
	
	_mask = NULL;
}

TCalcButton::~TCalcButton()
{
	if( _mask )
	{
		delete [] _mask;
	}
}

void TCalcButton::setBounds( int Left, int Top, int Width, int Height )
{
   _left = Left;
   _top = Top;
   _width = Width;
   _height = Height;
}

void TCalcButton::setName( const char* Name )
{
   if( _name )
   {
      delete _name;
   }
   _name = new char[ strlen( Name ) + 1 ];
   memcpy( _name, Name, strlen( Name ) + 1 );
}

void TCalcButton::setKey( int Key )
{
   _key = Key;
}

void TCalcButton::setKind( int Kind )
{
	_kind = Kind;
}

void TCalcButton::setChr( unsigned char Chr )
{
   _chr = Chr;
}

void TCalcButton::setActions( TButtonAction Action, TButtonAction Mode1Action,
                              TButtonAction Mode2Action, TButtonAction AlphaAction )
{
   _action = Action;
   _mode1action = Mode1Action;
   _mode2action = Mode2Action;
   _alphaaction = AlphaAction;
}


void TCalcButton::drawPressed( void )
{
	switch( _kind )
	{
		case 1:
		drawPressedKind1();
		break;
		
		case 2:
		drawPressedKind2();
		break;
		
		default:
		drawPressedKind0();
		break;
	}
}

void TCalcButton::makeHighlightMask( void )
{
   int x, y;
   RECT r;
   int lightmax, light, lightinc;
   int xstep, ystep;
   QColor color;
	QPen pen;
	QBrush brush;
	QPixmap pix;
	QPainter p;
	QImage img;
	
	if( _mask )
	{
		delete [] _mask;
	}

	pen.setStyle( Qt::SolidLine );
	brush.setStyle( Qt::SolidPattern );
	
	pix = QPixmap( _width, _height );
	p.begin( &pix, _owner );

	color = QColor( 0, 0, 0 );
	brush.setColor( color );
	p.fillRect( 0, 0, _width, _height, brush );
	
   x = ( _width / 2 );
   y = ( _height / 2 );
   lightmax = 60;
   light = 0;
   lightinc = lightmax / ( y > x ? x : y );
   if( !lightinc )
   {
      lightinc = 1;
   }

   if( y > x )
   {
      xstep = 1;
      ystep = y / x;
   }
   else
   {
      ystep = 1;
      xstep = x / y;
   }

   r.left = 0;
   r.top = 0;
   r.right = _width;
   r.bottom = _height;

   for( light = 0;
        light < lightmax && r.left < r.right && r.top < r.bottom;
        light += lightinc )
   {
      color = QColor( light, light, light );
		pen.setColor( color );
		brush.setColor( color );
		
		p.setPen( pen );
		p.setBrush( brush );
		p.drawEllipse( r.left, r.top, r.right - r.left + 1, r.bottom - r.top + 1 );
      
		r.left += xstep;
      r.top += ystep;
      r.right -= xstep;
      r.bottom -= ystep;
   }
   p.end();
	
	img = pix.convertToImage();
	_mask = new QRgb[ _width * _height ];
   for( y = 0; y < _height; y++ )
   {
      for( x = 0; x < _width; x++ )
      {
         _mask[ y * _width + x ] = img.pixel( x, y );
      }
   }
	
}

void TCalcButton::drawPressedKind0( void )
{
   QPainter p( _owner );
   QImage i = _owner->image().copy( _left, _top, _width - 1, _height - 1 );
   p.drawImage( _left + 1, _top + 1, i );
}

void TCalcButton::drawPressedKind1( void )
{
	QPen pen;
	QPixmap pix;
	QImage i;
	QPainter p;
	QColor color;
	
   i = _owner->image().copy( _left, _top, _width - 2, _height - 2 );
	pix = QPixmap( _width, _height );
	
	p.begin( &pix, _owner );	
	p.drawImage( 1, 1, i );
	pen.setStyle( Qt::SolidLine );
	color = QColor( 0, 0, 0 );
	pen.setColor( color );
	p.setPen( pen );
	p.drawLine( 0, _height - 1, 0, 0 );
	p.drawLine( 0, 0, _width - 1, 0 );
	color = QColor( 255, 255, 255 );
	pen.setColor( color );
	p.setPen( pen );
	p.drawLine( 0, _height - 1, _width - 1, _height - 1 );
	p.drawLine( _width - 1, _height - 1, _width - 1, 0 );
	p.end();
	
	i = pix.convertToImage();
	p.begin( _owner );
	p.drawImage( _left, _top, i );
	p.end();
}

void TCalcButton::drawPressedKind2( void )
{
   int x, y, k;
   int rgbtab[ 3 ];
   unsigned c, m, mval;
   unsigned msk = 0x000000FF;
	QPainter p;
	QColor color;
	
	if( !_mask )
	{
		makeHighlightMask();
	}
	
   QImage img = _owner->image().copy( _left, _top, _width, _height );
   
	for( y = 0; y < _height; y++ )
   {
      for( x = 0; x < _width; x++ )
      {
         c = (unsigned int)( img.pixel( x, y ) ); //b->Canvas->Pixels[ x ][ y ] );
         m = _mask[ y * _width + x ];
         for( k = 0; k < 3; k++ )
         {
            mval = m & msk; // & 0x000000FF;
            rgbtab[ k ] = ( c & msk ) + mval; // & 0x000000FF;
            if( rgbtab[ k ] > 254 )
            {
               rgbtab[ k ] = 254;
            }
            c = c >> 8;
            m = m >> 8;
         }
			color = QColor( rgbtab[ 0 ], rgbtab[ 1 ], rgbtab[ 2 ] );
         img.setPixel( x, y, color.rgb()  ); 
			//b->Canvas->Pixels[ x ][ y ] = (TColor)( RGB( rgbtab[ 0 ], rgbtab[ 1 ], rgbtab[ 2 ] ) );
      }
   }
   
	p.begin( _owner );
	p.drawImage( _left, _top, img );
	p.end();
}

void TCalcButton::drawNormal( void )
{
   QPainter p( _owner );
   QImage i = _owner->image().copy( _left, _top, _width, _height );
   p.drawImage( _left, _top, i );
}
//----------------------------------------------------------------------------
//
//
//
//----------------------------------------------------------------------------
TCalcButtonList::TCalcButtonList( void )
{
   _items = NULL;
   _count = 0;
}

TCalcButtonList::~TCalcButtonList()
{
   if( _count && _items )
   {
      Clear();
   }
}

void TCalcButtonList::Add( TCalcButton* Button )
{
   TCalcButton** tmp;

   if( Button )
   {
      tmp = new TCalcButton*[ _count + 1 ];
      if( _count && _items )
      {
         int j;
         for( j = 0; j < _count; j++ )
         {
            tmp[ j ] = _items[ j ];
         }
         delete _items;
      }
      tmp[ _count ] = Button;
      _items = tmp;
      _count++;
   }
}

void TCalcButtonList::Clear( void )
{
   int j;

   for( j = 0; j < _count; j++ )
   {
      if( _items[ j ] )
      {
         delete _items[ j ];
      }
   }
   delete _items;
   _items = NULL;
   _count = 0;
}

int TCalcButtonList::count( void )
{
   return _count;
}

TCalcButton* TCalcButtonList::item( int index )
{
   TCalcButton* b = NULL;

   if( index >= 0 && index < _count )
   {
      b = _items[ index ];
   }
   return b;
}

TCalcButton* TCalcButtonList::itemAt( int x, int y )
{
   TCalcButton* button = NULL;
   int j = 0;
   int l, t, r, b;

   for( j = 0; j < _count && !button; j++ )
   {
      l = _items[ j ]->left();
      t = _items[ j ]->top();
      r = l + _items[ j ]->width();
      b = t + _items[ j ]->height();
      
      if( x >= l && x <= r && y >= t && y <= b )
      {
         button = _items[ j ];
      }
   }
   return button;
}

TCalcButton* TCalcButtonList::getByKeyCode( int keycode )
{
   TCalcButton* button = NULL;
   int j = 0;

   for( j = 0; j < _count && !button; j++ )
   {
      if( _items[ j ]->key() == keycode )
      {
         button = _items[ j ];
      }
   }
   return button;
}

//---------------------------------------------------------------------------------------
TCalcButton* TCalcButtonList::GetButtonByAction( TButtonAction Action )
{
   TCalcButton* b = NULL;

   if( _items && _count )
   {
      int j;

      for( j = 0; j < _count && !b; j++ )
      {
         if( Action == _items[ j ]->action() ||
             Action == _items[ j ]->mode1action() ||
             Action == _items[ j ]->mode2action() ||
             Action == _items[ j ]->alphaaction()
           )
         {
            b = _items[ j ];
         }
      }
   }
   return b;
}
//----------------------------------------------------------------------------
//
//
//
//----------------------------------------------------------------------------
TButtonAction TranslateAction( const char* str )
{
   TButtonAction action;
   int j;

   j = 0;
   action = baUnknown;
   while( BtnDesc[ j ].action != baUnknown && action == baUnknown )
   {
      if( strcmp( BtnDesc[ j ].name, str ) == 0 )
      {
         action = BtnDesc[ j ].action;
      }
      else
      {
         j++;
      }
   }
   return action;
}

//----------------------------------------------------------------------------

int TranslateKey( const char* str )
{
   int keycode;
   unsigned int j;
   bool numeric;

   if( strlen( str ) == 0 )
   {
      return 0;
   }

   if( strlen( str ) > 1 )
   {   
      for( j = 0, numeric = true; j < strlen( str ) && numeric; j++ )
      {
         if( str[ j ] >= '0' && str[ j ] <= '9' )
         {
         }
         else
         {
            numeric = false;
         }
      }
   }
   else
   {
      numeric = false;
   }
   if( numeric )
   {
      int x;
      sscanf( str, "%d", &x );
      keycode = WinKeyToLinux( x );
      if( keycode == -1 )
      {
         keycode = x;
      }
   }
   else
   {
      keycode = str[ 0 ];
   }
   return keycode;
}
