/***************************************************************************
                          tcalcbutton.h  -  description
                             -------------------
    begin                : ?ro lis 6 2002
    copyright            : (C) 2002 by Piotr Gridniew
    email                : gridniew@x4.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TCALCBUTTON_H
#define TCALCBUTTON_H

#include "calctypes.h"

/**
  *@author Piotr Gridniew
  */

class TCalc;

class TCalcButton
{
  public: 
  TCalcButton( TCalc* AOwner );
  ~TCalcButton();

  void setBounds( int Left, int Top, int Width, int Height );
  void setName( const char* Name );
  void setKey( int Key );
  void setKind( int Kind );
  void setChr( unsigned char Chr );
  void setActions( TButtonAction Action, TButtonAction Mode1Action,
                   TButtonAction Mode2Action, TButtonAction AlphaAction );

  TCalc* owner() { return _owner; }
  const char* name() { return _name; }
  int left() { return _left; }
  int top() { return _top; }
  int width() { return _width; }
  int height() { return _height; }
  int key() { return _key; }
  int kind() { return _kind; }
  unsigned char chr() { return _chr; }
  TButtonAction action() { return _action; }
  TButtonAction mode1action() { return _mode1action; }
  TButtonAction mode2action() { return _mode2action; }
  TButtonAction alphaaction() { return _alphaaction; }

  void drawPressed( void );
  void drawNormal( void );

  private:
  TCalc* _owner;
  char* _name;
  int _left, _top;
  int _width, _height;
  int _key;
  int _kind;
  unsigned char _chr;
  TButtonAction _action;
  TButtonAction _mode1action;
  TButtonAction _mode2action;
  TButtonAction _alphaaction;
  QRgb* _mask;
  
  void makeHighlightMask( void );
  void drawPressedKind0( void );
  void drawPressedKind1( void );
  void drawPressedKind2( void );
};

class TCalcButtonList
{
   public:
   TCalcButtonList( void );
   ~TCalcButtonList();

   void Add( TCalcButton* Button );
   void Clear( void );

   int count( void );
   TCalcButton* item( int index );
   TCalcButton* itemAt( int x, int y );
   TCalcButton* getByKeyCode( int keycode );
   TCalcButton* GetButtonByAction( TButtonAction Action );
   
   private:
   int _count;
   TCalcButton** _items;
};

TButtonAction TranslateAction( const char* str );
int TranslateKey( const char* str );

#endif
