/***************************************************************************
                          tlcd.h  -  description
                             -------------------
    begin                : pon lis 18 2002
    copyright            : (C) 2002 by Piotr Gridniew
    email                : gridniew@x4.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TLCD_H
#define TLCD_H

#include "qpainter.h"
#include "astring.h"
#include "arect.h"
#include "tlcdfont.h"
#include "TInputLine.h"

/**
  *@author Piotr Gridniew
  */

class TCalc;
class TLCDDisplay;
//---------------------------------------------------------------------------------------
class TLCDHeaderSection
{
   public:
   TLCDDisplay* Owner;
   QString Text;
   int MaxLength;
   int Left;
   int pixLeft, pixSize;

   TLCDHeaderSection( TLCDDisplay* AOwner );
   ~TLCDHeaderSection();

   void SetMaxLength( int AMaxLength );
   void SetLeft( int ALeft );
   #ifdef __WIN32__
   void Draw( Canvas* ACanvas );
   #else
   void Draw( QPainter* APainter );
   #endif
};

//---------------------------------------------------------------------------------------
class TLCDDisplay
{
   private:
   TCalc* _owner;
   QImage* _image;
   QPixmap _pixmap;
   QPainter _painter;
   QRgb _fontcolor;
   QRgb _backcolor;
   int _left, _top;
   int _width, _height;
   int _trheight, _brheight;
   int _locks;

   int HeaderCount;
   TLCDHeaderSection** Headers;
   
   public:
   TLCDFont* Font;
   TLCDFont* SmFont;
   AnsiString FuncKey[ 6 ];
   TInputLine* InpLine;
   AnsiString InputBuffer;

   TLCDDisplay( TCalc* Owner );
   ~TLCDDisplay();

   bool LoadFonts( QString NormalFont, QString SmallFont );
   
   void CreateHeaderSections( int AHeaderCount = 6 );
   void setHeaderText( int Index, const char* Text );
   void setFuncKey( int Index, const char* Text );
   
   void setFontColor( QRgb color );
   void setBackColor( QRgb color );
   void setBounds( int Left, int Top, int Width, int Height );
   void setBRHeight( int Value );
   void setTRHeight( int Value );

   int left( void ) { return _left; }
   int top( void ) { return _top; }
   int width( void ) { return _width; }
   int height( void ) { return _height; }
   int colCount( void ) { return _width / Font->fontWidth(); }
   int rowCount( void ) { return ( _height - _trheight - _brheight ) / Font->fontHeight(); }
   int trheight( void ) { return _trheight; }
   int brheight( void ) { return _brheight; }
   TCalc* owner( void ) { return _owner; }
   int backcolor( void ) { return _backcolor; }
   int fontcolor( void ) { return _fontcolor; }
   QPixmap* pixmap( void ) { return &_pixmap; }
   QPainter* painter( void ) { return &_painter; }
   
   int getMaxWinHeight( void ) { return _height - ( _trheight + _brheight ); }

   void begin( void );
   void end( void );
   void paint( void );
   void clear( void );
   void drawLine( int x1, int y1, int x2, int y2, QRgb Color = 0 );
   void drawRect( int x1, int y1, int w, int h, QRgb Color = 0 );
   void printText( int X, int Y, AnsiString Text, TLCDFont* AFont = NULL );
   void fillRect( int x1, int y1, int w, int h, QRgb Color = 0 );
   //void fillRect( RECT& r, QRgb Color );
   void invertRect( RECT& r );
   void InvertRect( RECT& r );
   void invertRow( int RowNum );
   
   void drawHeaders( void );
   void drawText( int X, int Y, const char* Text, TLCDFont* AFont = NULL );
   void drawFuncKeys( void );
};

#endif
