/***************************************************************************
                          tlcdfont.h  -  description
                             -------------------
    begin                : pon lis 18 2002
    copyright            : (C) 2002 by Piotr Gridniew
    email                : gridniew@x4.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TLCDFONT_H
#define TLCDFONT_H

#include "qimage.h"

/**
  *@author Piotr Gridniew
  */

class TCalc;
class TLCDDisplay;

class TLCDFont
{
   private:
   TLCDDisplay* _owner;
   QString _fname;
   QImage _img;
   QRgb _fontcolor;
   QRgb _backcolor;
   int _width, _height;
   int _fontwidth, _fontheight;
   
   public: 
   TLCDFont( TLCDDisplay* AOwner = NULL );
   ~TLCDFont();

   bool LoadFont( QString FileName );
   void setFontColor( QRgb color );
   void setBackColor( QRgb color );

   int fontWidth( void ) { return _fontwidth; }
   int fontHeight( void ) { return _fontheight; }
   QImage image( void ) { return _img; }

   QRect getCharRect( int chr );
   void drawChar( QPainter* p, int x, int y, int chr, bool Inverse = false );
};

#endif
