#ifdef __WIN32__
#include "TCalc.h"
#else
#include "pgcalc.h"
#endif
#include "uCalcAlg.h"
#include "uCalcWin.h"

//---------------------------------------------------------------------------
TCalcAlg::TCalcAlg( TCalc* AOwner )
   : TCalcObject( AOwner )
{
   SetName( "CalcALG" );
   Inter = Owner->Inter;
   History = Owner->History;
   hPos = 0;
   hStart = 0;
   
   Results = new TStringList();
}
//---------------------------------------------------------------------------
TCalcAlg::~TCalcAlg( void )
{
   delete Results;
}
//---------------------------------------------------------------------------
void TCalcAlg::SetMode( int AMode )
{
   Mode = AMode;
   switch( AMode )
   {
      case 0:
      DefFunc( 1, "", baUnknown );
      DefFunc( 2, "", baUnknown );
      DefFunc( 3, "", baUnknown );
      DefFunc( 4, "", baUnknown );
      DefFunc( 5, "PASTE", baPaste );
      DefFunc( 6, "CLEAR", baClear );
      //CStackDispPos = 0;
      //CStackPos = 0;
      //CNewStackPos = 0;
      Owner->AllowMenu();
      break;

      case 1:
      DefFunc( 1, "", baUnknown );
      DefFunc( 2, "", baUnknown );
      DefFunc( 3, "ECHO", baEcho );
      DefFunc( 4, "DROP", baDrop );
      DefFunc( 5, "COPY", baCopy );
      DefFunc( 6, "CANCL", baCancel );
      Owner->DisallowMenu();
      break;
   }
   hPos = 0;
   hStart = 0;
}
//---------------------------------------------------------------------------
void TCalcAlg::Refresh( void )
{
   int j, i, x, lcount;
   //THistoryItem* hist;
   AnsiString p;
   atom a;
   
   LCD->begin();
   TCalcObject::Refresh();
   
	lcount = ( LCD->InpLine->Buffer.Length() > 0 ? LCD->rowCount() - 1 : LCD->rowCount() );
   x = ( lcount == LCD->rowCount() ? 0 : 1 );
   
	LCD->fillRect( 0, LCD->trheight(), LCD->width() - 1,
                  LCD->height() - LCD->trheight() - LCD->brheight(), LCD->backcolor() );
   
	for( j = lcount - 1; j >= 0; j-- )
   {
      /*
      i = ( lcount - 1 - j ) / 2;
      hist = Results->item( Results->count() - i - 1 );
      if( hist )
      {
         if( j % 2 )
         {
            a = hist->result();
            p = AnsiString( a.getstring() );
            if( LCD->colCount() - p.Length() <= 0 )
            {
               LCD->printText( 0, i * 2 + x, p.SubString( 1, LCD->colCount() - 1 ) + AnsiString( (char)( 127 ) ) );
            }
            else
            {
               LCD->printText( LCD->colCount() - p.Length(), i * 2 + x, p );
            }
         }
         else
         {
            p = hist->expstr();
            LCD->printText( 0, i * 2 + 1 + x, ":" + p );
         }
      }
      */
      i = ( lcount - 1 - j );
      if( i + hStart < Results->Count() )
      {
         p = Results->String( i + hStart );
         if( ( i + hStart ) % 2 )
         {
            LCD->printText( 0, i + x, ":" + p );
         }
         else
         {
            if( LCD->colCount() - p.Length() <= 0 )
            {
               LCD->printText( 0, i + x, p.SubString( 1, LCD->colCount() - 1 ) + AnsiString( (char)( 127 ) ) );
            }
            else
            {
               LCD->printText( LCD->colCount() - p.Length(), i + x, p );
            }
         }
      }
   }
      
   if( x == 1 )
   {
         //LCD->PrintText( 0, 0, LCD->InpLine->Buffer );
      LCD->InpLine->Draw();
   }

   if( Mode ) //&& CNewHistPos != CHistPos )
   {
      LCD->invertRow( hPos );
   } 
      
   if( Child )
   {
      Child->Refresh();
   }
   LCD->end();
}
//---------------------------------------------------------------------------
void TCalcAlg::Activate( void )
{
   SetMode( 0 );
   LCD->setHeaderText( 1, "ALG" );
   LCD->InputBuffer = "";
   LCD->InpLine->SetStyle( ilsAllStyles );
                           /*
                           ilsAllowNumber | 
                           ilsAllowDot | 
                           ilsAllowSeparator |
                           ilsAllowChar | 
                           ilsAllowBrace |
                           ilsAllowString | 
                           ilsAllowOperator |
                           ilsAllowFunc |
                           ilsAllowExpression |
                           ilsAllowSymbol );
                           */
   Refresh();
}
//---------------------------------------------------------------------------
void TCalcAlg::ExecActionMode1( TButtonAction& Action )
{
   bool lProcessed = true;
   int i;
   
   if( Action == baCancel )
   {
      SetMode( 0 );
   }
   else if( Action == baUp )
   {
      if( hPos + hStart < Results->Count() - 1 )
      {
         if( hPos < LCD->rowCount() - 1 )
         {
            hPos++;
         }
         else
         {
            hStart++;
         }
      }
      else
      {
         lProcessed = false;
      }
   }
   else if( Action == baDown )
   {
      if( hPos > 0 )
      {
         hPos--;
      }
      else if( hStart > 0 )
      {
         hStart--;
      }
      else
      {
         lProcessed = false;
      }
   }
   else if( Action == baEcho )
   {
      LCD->InpLine->Clear();
      LCD->InpLine->InsertText( Results->String( hPos + hStart ) );
      SetMode( 0 );
   }
   else if( Action == baDrop )
   {
      i = ( hPos + hStart ) / 2;
      Results->Delete( i * 2 + 1 );
      Results->Delete( i * 2 );
      SetMode( 0 );
   }
   else
   {
      lProcessed = false;
   }

   if( lProcessed )
   {
      Action = baUnknown;
		Refresh();
   }
}
//---------------------------------------------------------------------------
void TCalcAlg::ExecAction( TButtonAction& Action )
{
   atom a;
   AnsiString p;
   bool lProcessed = true;
   
   TCalcObject::ExecAction( Action );
   if( Action == baUnknown || Child )
   {
      return;
   }

   if( Action >= baF1 && Action <= baF6 )
   {
      Action = GetFunc( Action );
   }
   
   if( Mode )
   {
      ExecActionMode1( Action );
      return;
   }
   
   if( Eval( Action ) )
   {
      Action = baUnknown;
		Refresh();
      return;
   }
   
   if( Action == baEnter && Inter )
   {
      if( Inter->fromString( LCD->InpLine->Buffer ) )
      {
          if( Inter->calcExp() )
          {
             p = LCD->InpLine->Buffer;
             a = Inter->Result();
             
             LCD->InpLine->Clear();

             Results->Insert( 0, p );
             Results->Insert( 0, AnsiString( a.getstring() ) );
             if( History )
             {
                History->Insert( 0, p ); //
             }
          }
          else
          {
             ErrMsg( Inter->errorStr() );
             LCD->InpLine->SetCursorPos( Inter->errorPos() );
          }
      }
      else
      {
         ErrMsg( Inter->errorStr() );
         LCD->InpLine->SetCursorPos( Inter->errorPos() );
      }
   }
   else if( Action == baUp )
   {
      if( Results->Count() && LCD->InpLine->Buffer.Length() == 0 )
      {
         SetMode( 1 );
      }
      else
      {
         lProcessed = false;
      }
   }
   else if( Action == baHist )
   {
   }
   else if( Action == baClear && LCD->InpLine->Buffer.Length() == 0 )
   {
      Results->Clear();
   }
   else
   {
      lProcessed = false;
   }
   
   if( lProcessed )
   {
      Action = baUnknown;
		Refresh();
   }
}
//---------------------------------------------------------------------------
bool TCalcAlg::Eval( TButtonAction Action )
{ 
   bool res = false;
   AnsiString p;
   
   if( Action == baConvert && LCD->InpLine->Buffer.Pos( "_" ) )
   {
   }
   else //if( Action != baEnter )
   {
      res = LCD->InpLine->ExecAction( Action );
      //res = true;
   }
   return res;
}
//---------------------------------------------------------------------------
void TCalcAlg::SaveState( xmlnode* node )
{
   if( node )
   {
      xmltree* xtree = (xmltree*)( node->getowner() );
      if( xtree )
      {
         xmlnode* xitems;
         int j;
         
         xitems = xtree->addNode( "Items", "", node );     
         for( j = 0; j < Results->Count(); j++ )
         {
            xtree->addNode( "Item", Results->String( j ), xitems );
         }
      }
   }
}
//---------------------------------------------------------------------------
void TCalcAlg::LoadState( xmlnode* node )
{
   if( node )
   {
      xmltree* xtree = (xmltree*)( node->getowner() );
      if( xtree )
      {
         xmlnode* xitems = node->getNodeByName( "Items" );
         if( xitems )
         {
            xmlnode* n = xitems->getFirstCh();
            
            while( n )
            {
               Results->Add( n->getValue() );
               n = n->getNext();
            }
         }
      }
   }
}
//---------------------------------------------------------------------------

