#include "uCalcMnu.h"

#ifdef __WIN32__
#include "TCalc.h"
#else
#include "pgcalc.h"
#endif
//---------------------------------------------------------------------------
//
//
//---------------------------------------------------------------------------
TCalcMenuItems::TCalcMenuItems( void )
{
   _items = NULL;
   _count = 0;
}
//---------------------------------------------------------------------------
TCalcMenuItems::~TCalcMenuItems()
{
   Clear();
}
//---------------------------------------------------------------------------
void TCalcMenuItems::Add( TCalcMenuItem* Item )
{
   if( Item )
   {
      TCalcMenuItem** tmp;
      int j;
      
      tmp = new TCalcMenuItem*[ _count + 1 ];
      if( _count && _items )
      {
         for( j = 0; j < _count; j++ )
         {
            tmp[ j ] = _items[ j ];
         }
         delete [] _items;
      }
      tmp[ _count ] = Item;
      _count++;
      _items = tmp;
   }
}
//---------------------------------------------------------------------------
void TCalcMenuItems::Add( AnsiString Caption, int Command )
{
   TCalcMenuItem* a = new TCalcMenuItem( Caption, Command );
   Add( a );
}
//---------------------------------------------------------------------------
void TCalcMenuItems::Clear( void )
{
   if( _count && _items )
   {
      int j;
      for( j = 0; j < _count; j++ )
      {
         delete _items[ j ];
      }
      delete [] _items;
      _items = NULL;
      _count = 0;
   }
}
//---------------------------------------------------------------------------
TCalcMenuItem* TCalcMenuItems::Item( int Index )
{
   TCalcMenuItem* i = NULL;
   
   if( Index >= 0 && Index < _count && _items )
   {
      i = _items[ Index ];
   }
   return i;
}
//---------------------------------------------------------------------------
//
//
//---------------------------------------------------------------------------
TCalcMenu::TCalcMenu( TCalc* AOwner, TCalcObject* AParent )
   : TCalcWin( AOwner, AParent )
{
   FCaption = "*** MENU ***";
   Items = new TCalcMenuItems();
   sb = new TCalcScrollBar( LCD );
   CStart = 0;
   CVisible = 0;
   CPos = 0;
   SetShadow( 2 );
   SetButtons( btOkCancel );
   SetInvertCaption( true );
   maxh = 0;
}
//---------------------------------------------------------------------------
TCalcMenu::~TCalcMenu()
{
   delete Items;
   delete sb;
   if( Parent )
   {
      Parent->SetChild( NULL );
   }
}
//---------------------------------------------------------------------------
void TCalcMenu::SetBounds( int Left, int Top, int Width, int Height )
{
   // int x, h;
   
   //x = LCD->SmFont->fontHeight() + 7;
   //h = ( Height - x ) % ( LCD->SmFont->fontHeight() + 2 );
   //if( h )
   //{
   //   Height -= h;
   //}
   TCalcWin::SetBounds( Left, Top, Width, Height );
   //CVisible = FClientHeight / ( LCD->SmFont->fontHeight() % 2 );
}
//---------------------------------------------------------------------------
void TCalcMenu::Activate( void )
{
   //MessageBox( 0, "Before Mnu Activate!", "", MB_OK );
   TCalcWin::Activate();   
   //Refresh();
   //MessageBox( 0, "After Mnu Activate!", "", MB_OK );
}
//---------------------------------------------------------------------------
void TCalcMenu::Refresh( void )
{
   int x, y, j;
   int sbx, sby, sbw, sbh;
   RECT r;

   LCD->begin();
   
   TCalcWin::Refresh();

   sbx = FLeft + FWidth - 7;
   sbw = 5;
   sby = FTop + LCD->SmFont->fontHeight() + 6;
   sbh = CVisible * ( LCD->SmFont->fontHeight() + 2 ) - 1;
   sb->SetBounds( sbx, sby, sbw, sbh );
   sb->SetLayout( 0, Items->Count() - 1, CVisible );
   sb->SetStyle( csbVert );
   sb->SetPosition( CPos );
   if( sb->Visible() )
   {
      sb->Draw();
   }
   else
   {
      sbw = 0;
   }
   
   y = FTop + LCD->SmFont->fontHeight() + 7;
   x = FLeft + 3;
   for( j = CStart; j < CStart + CVisible && j < Items->Count(); j++ )
   {
      LCD->drawText( x, y, Items->Item( j )->Caption().c_str(), LCD->SmFont );
      y += ( LCD->SmFont->fontHeight() + 2 );
   }
   r.left = FLeft + 2;
   r.top = FTop + LCD->SmFont->fontHeight() + 6 + ( ( CPos - CStart ) * ( LCD->SmFont->fontHeight() + 2 ) );
   r.right = FLeft + FWidth - 4 - sbw;
   r.bottom = r.top + LCD->SmFont->fontHeight() + 1;
   LCD->invertRect( r );

   LCD->end();
}
//---------------------------------------------------------------------------
void TCalcMenu::SetDefault( int Default )
{
   CPos = Default;   
   if( CPos > CStart )
   {
      if( CPos > Items->Count() - CVisible )
      {
         CStart = Items->Count() - CVisible;
      }
      else
      {
         CStart = CPos;
      }
   }
}
//---------------------------------------------------------------------------
void TCalcMenu::SetPosition( int Pos )
{
   CPos = Pos;
   if( CPos > CStart )
   {
      if( CPos > Items->Count() - CVisible )
      {
         CStart = Items->Count() - CVisible;
      }
      else
      {
         CStart = CPos;
      }
   }
   else
   {
      CStart = CPos;
   }
   //Refresh();
}
//---------------------------------------------------------------------------
void TCalcMenu::AddItem( AnsiString Caption, int Command )
{
   int x, i, h;
   
   Items->Add( Caption, Command );
   
   x = LCD->getMaxWinHeight(); //LCD->Height - ( LCD->TRHeight + LCD->BRHeight ) - LCD->SmFont->fontHeight();
   if( FCaption.Length() > 0 )
   {
      i = LCD->SmFont->fontHeight() + 7;
      x -= i;
   }
   else
   {
      i = 0;
   }
   

   if( Items->Count() * ( LCD->SmFont->fontHeight() + 2 ) < x )
   {
      h = i + ( Items->Count() * ( LCD->SmFont->fontHeight() + 2 ) );
      CVisible = Items->Count();
   }
   else
   {
      CVisible = x / ( LCD->SmFont->fontHeight() + 2 ) - 1;
      h = i + ( CVisible * ( LCD->SmFont->fontHeight() + 2 ) );
   }
   SetBounds( 0, 0, LCD->width() - 20, h );
   //SetBounds( 10, 10, 230, 100 );
   //MessageBox( 0, Caption.c_str(), "AddItem", MB_OK );
}
//---------------------------------------------------------------------------
void TCalcMenu::ExecAction( TButtonAction& Action )
{
   bool lProcessed = true;
   AnsiString p;
   int j, pos, chr;
   
   if( Action >= baF1 && Action <= baF6 )
   {
      Action = GetFunc( Action );
   }
   
   if( Action == baCancel ) //|| Action == baClose )
   {
      Result = 0;//baUnknown;
      RestoreFunc();
      Close();
   }
   else if( Action == baMode1 && Action == baMode2 && Action == baAlpha )
   {
   }
   else if( Action == baEnter || Action == baOk )
   {
      Result = Items->Item( CPos )->Command();
      RestoreFunc();
      Close();
      //Calc.SendAction( _result );
   }
   else if( Action == baDown )
   {
      if( CPos < Items->Count() - 1 )
      {
         CPos++;
      }
      else
      {
         CPos = 0;
      }
      
      if( CPos >= CStart + CVisible )
      {
         CStart = CPos - CVisible + 1; 
      }
      else if( CPos < CStart )
      {
         CStart = CPos;
      }
   }
   else if( Action == baUp )
   {
      if( CPos > 0 )
      {
         CPos--;
      }
      else
      {
         CPos = Items->Count() - 1;
      }
      
      if( CPos < CStart )
      {
         CStart = CPos;
      }
      else if( CPos >= CStart + CVisible )
      {
         CStart = CPos - CVisible + 1;
      }
   }
   else if( Action != baUnknown )
   {  
      pos = -1;
      if( Owner )
      {
         TCalcButton* b = Owner->GetButtonByAction( Action );
         
         if( b )
         {
            chr = b->chr();
            p = AnsiString( (char)( chr ) );
            
            for( j = 0; j < Items->Count() && pos == -1; j++ )
            {
               if( Items->Item( j )->Caption().Pos( p ) == 1 )
               {
                  //MessageBox( Owner->Handle, Items->Item( j )->Caption().c_str(), "Key", MB_OK );
                  pos = j;
               }
            }
            
         }
      }
      if( pos >= 0 )
      {
         SetPosition( pos );
      }
      else
      {
         lProcessed = false;
      }
   }
   
   if( lProcessed )
   {
      Refresh();
      Action = baUnknown;
   }
}
//---------------------------------------------------------------------------
int TCalcMenu::ShowModal( void )
{
	return TCalcObject::ShowModal();
}
//---------------------------------------------------------------------------

