#ifdef __WIN32__
#include "TCalc.h"
#else
#include "pgcalc.h"
#endif

#include "atomutil.h"
#include "uCalcTVM.h"
#include "TInputBox.h"
//---------------------------------------------------------------------------
TCalcTVM::TCalcTVM( TCalc* AOwner )
   : TCalcObject( AOwner ),
     _result( -1 ),
     hPos( 0 ),
     _parentName( "" ),
     _f6_text( "CLOSE" ),
     _stack( NULL ),
     _inter( NULL )
{
   int j;

   _names[ 0 ] = "PN";
   _names[ 1 ] = "PY";
   _names[ 2 ] = "IYR";
   _names[ 3 ] = "PV";
   _names[ 4 ] = "PMT";
   _names[ 5 ] = "FV";
   
   _descs[ 0 ] = "PN  :";
   _descs[ 1 ] = "P/Y :";
   _descs[ 2 ] = "I%YR:";
   _descs[ 3 ] = "PV  :";
   _descs[ 4 ] = "PMT :";
   _descs[ 5 ] = "FV  :";
   
   for( j = 0; j < 6; j++ )
   {
      if( j == 1 )
		{
			_values[ j ] = 12.0;
		}
		else
		{
			_values[ j ] = 0.0;
		}
   }
   SetName( "CalcTVM" );
}
//---------------------------------------------------------------------------
TCalcTVM::~TCalcTVM( void )
{
}
//--------------------------------------------------------------------------- 
void TCalcTVM::setParentName( AnsiString AName )
{
   AnsiString p = AName.UpperCase();

   if( p.Pos( "RPN" ) )
   {
      _f6_text = AnsiString( (char)16 ) + "STCK";
      _parentName = "RPN";
   }
   else if( p.Pos( "ALG" ) )
   {
      _f6_text = AnsiString( (char)16 ) + "EXPR";
      _parentName = "ALG";
   }
   else
   {
   }
}
//---------------------------------------------------------------------------
void TCalcTVM::assignStack( atomstack* AStack )
{
   _stack = AStack;
}
//---------------------------------------------------------------------------
void TCalcTVM::assignInter( atominter* AInter )
{
   _inter = AInter;
}
//---------------------------------------------------------------------------
void TCalcTVM::Refresh( void )
{
   int j, rcount, ccount;
   AnsiString p;
   char buf[ 30 ];
   
   LCD->begin();
   TCalcObject::Refresh();

   rcount = LCD->rowCount() - 1;
   ccount = LCD->colCount() - 4 - 2;

   LCD->fillRect( 0, LCD->trheight(), LCD->width() - 1,
                  LCD->height() - LCD->trheight() - LCD->brheight(), LCD->backcolor() );
   
	for( j = 0, p = ""; j < LCD->colCount(); j++ )
   {
      p += AnsiString( (char)( 31 ) );
   }
   LCD->printText( 0, rcount, p );
   p = "[TVM SOLVER]";
   LCD->printText( ( LCD->colCount() - p.Length() ) / 2, rcount, p );
   
   for( j = 0; j < 6; j++ )
   {
      LCD->printText( 0, rcount - j - 1, _descs[ j ] );
      sprintf( buf, "%*.2f", ccount, _values[ j ] );
      LCD->printText( 6, rcount - j - 1, AnsiString( buf ) );
   }  
   LCD->invertRow( rcount - hPos - 1 );
   
   if( Child )
   {
      Child->Refresh();
   }
   LCD->end();
}
//---------------------------------------------------------------------------
void TCalcTVM::Activate( void )
{
   Open();
   
   DefFunc( 1, "EDIT", baEdit );
   DefFunc( 2, "SOLVE", baSolve );
   DefFunc( 3, "", baUnknown );
   DefFunc( 4, "", baUnknown );
   DefFunc( 5, "CANCL", baCancel );
   DefFunc( 6, _f6_text, baOk );
   Owner->DisallowMenu();
}
//---------------------------------------------------------------------------
void TCalcTVM::ExecAction( TButtonAction& Action )
{
   bool lProcessed = true;
   // int rcount = LCD->rowCount() - 1;
   AnsiString p;

   TCalcObject::ExecAction( Action );
   if( Action == baUnknown || Child )
   {
      return;
   }

   if( Action >= baF1 && Action <= baF6 )
   {
      Action = GetFunc( Action );
   }
   
   if( Action == baOk )
   {
      if( _stack && _parentName == "RPN" )
      {
         atom a = atom( _values[ hPos ] );
         _stack->push( a );
      }
      Close();
   }
   else if( Action == baCancel )
   {
      Close();
   }   
   else if( Action == baEdit || Action == baEnter )
   {
      EditValue( hPos, "" );
   }
   else if( Action >= ba0 && Action <= ba9 )
   {
      p = AnsiString( (char)( Action - ba0 + 48 ) );
      EditValue( hPos, p );
   }
   else if( Action == baSub || Action == baNeg )
   {
      EditValue( hPos, "-" );
   }
   else if( Action == baSolve && hPos != 1 ) //hPos >= 3 && hPos <= 5 )
   {
      Solve( hPos );
   }
   else if( Action == baUp )
   {
      if( hPos > 0 )
      {
         hPos--;
      }
      else
      {
         hPos = 5;
      }
   }
   else if( Action == baDown )
   {
      if( hPos < 5 )
      {
         hPos++;
      }
      else
      {
         hPos = 0;
      }
   }
   else
   {
      lProcessed = false;
   }
   
   if( lProcessed )
   {
      Action = baUnknown;
      #ifndef __WIN32__
      Refresh();
      #endif
   }
}
//---------------------------------------------------------------------------
void TCalcTVM::EditValue( int Pos, AnsiString InitText )
{
   int res;
   AnsiString value;

	if( Pos ) {}
   
   TInputBox* ib = new TInputBox( Owner, this );
   ib->SetPrompt( "Value of " + AnsiString( _descs[ hPos ] ) );
   ib->SetStyle( ilsAllowNumber | ilsAllowDot );
   ib->SetButtons( btOk | btCancel );
   if( InitText.Length() > 0 )
   {
      ib->SetText( InitText );
   }
   else
   {
      if( _values[ hPos ] != 0.0 )
      {
         ib->SetText( DoubleToStr( _values[ hPos ] ) );
      }
   }
   res = ib->ShowModal();
   value = ib->GetText();
   delete ib;
   
   if( res == mrOk )
   {
      _values[ hPos ] = StrToDouble( value );
      if( hPos < 5 )
      {
         hPos++;
      }
      else
      {
         hPos = 0;
      }
   }
   Owner->setActiveObject( this );
}
//---------------------------------------------------------------------------
void TCalcTVM::Solve( int Pos )
{
   double N, I, PV, PMT, FV;
   
   if( _values[ 1 ] == 0.0 )
   {
      return;
   }   
   
   N = _values[ 0 ];
   I = _values[ 2 ] / 12.0; //( 12.0 / _values[ 1 ] );
   if( Pos == 0 )
   {
      PV = _values[ 3 ];
      PMT = _values[ 4 ];
      FV = _values[ 5 ];
      if( PMT > 0.0 )
      {
         ErrMsg( "PMT should be less than zero!" );
      }
      else 
      {
         _values[ 0 ] = finance_nper( I, PMT, PV, FV );
      }      
   }   
   else if( Pos == 2 )
   {
      PV = _values[ 3 ];
      PMT = _values[ 4 ];
      FV = _values[ 5 ];
      if( PMT > 0.0 )
      {
         ErrMsg( "PMT should be less than zero!" );
      }
      else 
      {
         _values[ 2 ] = finance_rate( N, PMT, PV, FV );
      }   
   }   
   else if( Pos == 3 )
   {
      // Solve PV
      PMT = _values[ 4 ];
      FV = _values[ 5 ];
      _values[ 3 ] = finance_pvex( N, I, FV, PMT, 0.0 );
   }
   else if( Pos == 4 )
   {
      // Solve PMT
      PV = _values[ 3 ];
      FV = _values[ 5 ];
      _values[ 4 ] = finance_paymtex( N, I, PV, FV, 0.0 );
   }
   else if( Pos == 5 )
   {
      // Solve FV
      PV = _values[ 3 ];
      PMT = _values[ 4 ];
      _values[ 5 ] = finance_fvex( N, I, PV, PMT, 0.0 );
   }
}
//---------------------------------------------------------------------------
/*
int TCalcTVM::ShowModal( void )
{
   #ifdef __WIN32__
	MSG msg;

   Activate();   
   while( !IsClosed() ) // msg.message != WM_QUIT ) //&& Calc.Handle )
   {
      if( GetMessage( &msg, NULL, 0, 0 ) )
      {
            TranslateMessage( &msg );
            DispatchMessage( &msg );
      }
      else
      {
            Close();
      }
   }
	#else
   Calc->setActiveObject( this );

   _result = -1;
   while( !IsClosed() ) //&& !Calc->Terminated() ) // msg.message != WM_QUIT )
   {
      App->processEvents();
   }
   #endif
	
	return _result;
}
*/
//---------------------------------------------------------------------------
void TCalcTVM::SaveState( xmlnode* node )
{
   if( node )
   {
      xmltree* xtree = (xmltree*)( node->getowner() );
      if( xtree )
      {
         xmlnode* xregs;
         int j;

         xregs = xtree->addNode( "Registers", "", node );
         for( j = 0; j < 6; j++ )
         {
             xtree->addNode( _names[ j ], DoubleToStr( _values[ j ] ), xregs );
         }         
      }
   }
}
//---------------------------------------------------------------------------
void TCalcTVM::LoadState( xmlnode* node )
{
   if( node )
   {
      xmltree* xtree = (xmltree*)( node->getowner() );
      if( xtree )
      {
         xmlnode* xregs = node->getNodeByName( "Registers" );
         if( xregs )
         {
            int j;
            
            for( j = 0; j < 6; j++ )
            {
               _values[ j ] = xregs->readDouble( _names[ j ] );
            }
         }
      }
   }
}
//---------------------------------------------------------------------------

