#ifndef _UCALCTVM_H
#define _UCALCTVM_H

#include "astack.h"
#include "ainter.h"
#include "ucalcobj.h"
//---------------------------------------------------------------------------
class TCalcTVM : public TCalcObject
{
   private:
   int _result;
   int hPos;
   AnsiString _parentName;
   AnsiString _f6_text;
   AnsiString _names[ 6 ];
   AnsiString _descs[ 6 ];
   double _values[ 6 ];
   atomstack* _stack;
   atominter* _inter;
   
   public:
   TCalcTVM( TCalc* AOwner );
   ~TCalcTVM( void );
   
   void setParentName( AnsiString AName );
   void assignStack( atomstack* AStack );
   void assignInter( atominter* AInter );
   
   void Refresh( void );
   void Activate( void );
   void ExecAction( TButtonAction& Action );
   
   void EditValue( int Pos, AnsiString InitText );
   void Solve( int Pos );
   
   void SaveState( xmlnode* node );  
   void LoadState( xmlnode* node );
   //int ShowModal( void );
};
//---------------------------------------------------------------------------
#endif // _UCALCTVM_H

