#ifdef __WIN32__
#include "TCalc.h"
#else
#include "pgcalc.h"
#endif

#include <atomutil.h>
#include "uCalcVar.h"
#include "uCalcWin.h"
#include "uCalcMnu.h"
#include "TInputBox.h"

//---------------------------------------------------------------------------
TCalcVarList::TCalcVarList( TCalc* AOwner )
   : TCalcObject( AOwner ),
     _result( 0 ),
     _var( NULL ),
     _const( NULL ),
     hPos( 0 ),
     hStart( 0 ),
     _f6_text( "SELECT" )
{
   SetName( "CalcVAR" );
}
//---------------------------------------------------------------------------
TCalcVarList::~TCalcVarList( void )
{
}
//---------------------------------------------------------------------------
void TCalcVarList::setParentName( AnsiString AName )
{
   AnsiString p = AName.UpperCase();

   if( p.Pos( "RPN" ) )
   {
      _f6_text = AnsiString( (char)16 ) + "STCK";
   }
   else if( p.Pos( "ALG" ) )
   {
      _f6_text = AnsiString( (char)16 ) + "EXPR";
   }
   else
   {
   }
}
//---------------------------------------------------------------------------
void TCalcVarList::assignVariables( atomlist* AList )
{
   _var = AList;
}
//---------------------------------------------------------------------------
void TCalcVarList::assignConstants( atomlist* AList )
{
   _const = AList;
}
//---------------------------------------------------------------------------
void TCalcVarList::Refresh( void )
{
   int i, j, rcount;
   AnsiString p;
   atom a;
   char buf[ 100 ];
   
   rcount = LCD->rowCount() - 1;
   //LCD->textOut( 0, LCD->trheight(), 999, "====== CONSTANTS LIBRARY =======", LCD->SmFont );
   
	LCD->begin();
   TCalcObject::Refresh();
   
	LCD->fillRect( 0, LCD->trheight(), LCD->width() - 1,
                  LCD->height() - LCD->trheight() - LCD->brheight(), LCD->backcolor() );
   
	for( j = 0, p = ""; j < LCD->colCount(); j++ )
   {
      p += AnsiString( (char)( 31 ) );
   }
   LCD->printText( 0, rcount, p );
   p = "[VARIABLES]";
   LCD->printText( ( LCD->colCount() - p.Length() ) / 2, rcount, p );
   
   for( j = rcount - 1; j >= 0; j-- )
   {
      i = rcount - j - 1;
      if( i + hStart < _var->count() )
      {
         //MessageBox( Owner->Handle, _var->getDesc( i + hStart ), "Const", MB_OK );
         sprintf( buf, "%-5s: %s", 
                  AnsiString( _var->getAtom( i + hStart ).name() ).SubString( 1, 5 ).c_str(),
                  _var->getAtom( i + hStart ).getstring( 12 ) );
         LCD->printText( 0, j, AnsiString( buf ) );
                  
         //p = AnsiString( _var->getAtom( i + hStart ).name() ) + ": " + 
         //    AnsiString( _var->getAtom( i + hStart ).getstring() );
         //LCD->printText( 0, j, p );
      }
   }
   if( hStart > 0 )
   {
      LCD->printText( LCD->colCount() - 1, rcount - 1, AnsiString( (char)( 19 ) ) );
   }
   if( hStart + rcount - 1 < _var->count() - 1 )
   {
      LCD->printText( LCD->colCount() - 1, 0, AnsiString( (char)( 18 ) ) );
   }
   LCD->invertRow( rcount - hPos - 1 );

   if( Child )
   {
      Child->Refresh();
   }
	LCD->end();
}
//---------------------------------------------------------------------------
void TCalcVarList::Activate( void )
{
   Open();
   
   _result = -1;
   
   DefFunc( 1, "ADD", baAdd );
   DefFunc( 2, "", baUnknown );
   DefFunc( 3, "EDIT", baEdit );
   DefFunc( 4, "DEL", baDel );
   DefFunc( 5, "CANCL", baCancel );
   DefFunc( 6, _f6_text, baEnter );
   Owner->DisallowMenu();
}
//---------------------------------------------------------------------------
void TCalcVarList::ExecAction( TButtonAction& Action )
{
   bool lProcessed = true;
   int rcount = LCD->rowCount() - 1;
   
   TCalcObject::ExecAction( Action );
   if( Action == baUnknown || Child )
   {
      Refresh();
		return;
   }

   if( Action >= baF1 && Action <= baF6 )
   {
      Action = GetFunc( Action );
   }
   
   if( Action == baEnter || Action == baOk )
   {
      _result = hPos + hStart;
      Close();
   }
   else if( Action == baAdd )
   {
      EditVariable( true );
   }
   else if( Action == baEdit )
   {
      EditVariable( false );
   }
   else if( Action == baDel )
   {
      DeleteVariable();
   }
   else if( Action == baCancel )
   {
		//fprintf( stderr, "Cancel Action received...\n" );
      Close();
   }
   else if( Action == baUp )
   {
      if( hPos > 0 )
      {
         hPos--;
      }
      else if( hStart > 0 )
      {
         hStart--;
      }
   }
   else if( Action == baDown )
   {
      if( hPos + hStart < _var->count() - 1 )
      {
         if( hPos < rcount - 1 )
         {
            hPos++;
         }
         else 
         {
            hStart++;
         }
      }
   }
   else
   {
      lProcessed = false;
   }
   
   if( lProcessed )
   {
		Refresh();
      Action = baUnknown;
   }
}
//---------------------------------------------------------------------------
void TCalcVarList::EditVariable( bool IsNew )
{
   int res;
   int type;
   int vindex;
   int cindex;
   AnsiString name, value;
   atom a;

   if( !IsNew )
   {
      name = AnsiString( _var->getAtom( hPos + hStart ).name() );
   }
   else
   {
      name = "";
   }
   
   if( name.UpperCase() != "X" )
   {
      TInputBox* ib = new TInputBox( Owner, this );
      ib->SetPrompt( "Variable Name" );
      ib->SetButtons( btOk | btCancel );
      ib->SetStyle( ilsAllowChar | ilsAllowSymbol );
      if( !IsNew )
      {
         ib->SetText( name );
      }
      res = ib->ShowModal();
      name = ib->GetText();
      delete ib;
      Owner->setActiveObject( this );
		
      vindex = ( _var ? _var->findAtom( name.c_str() ) : -1 );
      cindex = ( _const ? _const->findAtom( name.c_str() ) : -1 );
      if( name.UpperCase() == "X" || 
         ( IsNew && vindex != -1 ) ||
         ( !IsNew && vindex != hPos + hStart )
        ) 
      {
         ErrMsg( "Variable already exists (vI=" + IntToStr( vindex ) + ")!" );
         return;
      }
      else if( cindex != -1 )
      {
         ErrMsg( "Constant '" + name + "' already exists!" );
         return;
      }
   }
   else
   {
      res = mrOk;
   }
        
   if( res == mrOk )
   {
      if( name.UpperCase() == "X" )
      {
         type = aDouble;
      }
      else
      {
         type = TypeMenu( !IsNew ? _var->getAtom( hPos + hStart ).type() : 0 );
      }
      
      if( type > 0 )
      {
         TInputBox* ibval = new TInputBox( Owner, this );
         ibval->SetPrompt( "Variable's Value" );
         ibval->SetButtons( btOk | btCancel );
         ibval->SetStyle( ilsAllStyles ); // ilsAllowNumber | ilsAllowDot );
         if( !IsNew )
         {
            if( type == _var->getAtom( hPos + hStart ).type() )
            {
               ibval->SetText( AnsiString( _var->getAtom( hPos + hStart ).getstring() ) );
            }
         }
         res = ibval->ShowModal();
         value = ibval->GetText();
         delete ibval;
         
         if( res == mrOk && value.Length() > 0 )
         {
            switch( type )
            {
               case aInteger:
               a = str2atom( value.c_str() );
               break;
               
               case aComplex:
               a = atom( StrToComplex( value ) );
               break;
               
               case aVector:
               a = atom( StrToVector( value ) );
               break;
            
               case aMeasure:
               a = atom( StrToMeasure( value ) );
               break;
               
               default:
               if( IsDouble( value ) )
               {
                  a = atom( StrToDouble( value ), aifDec );
               }
               else if( IsEDouble( value ) )
               {
                  a = atom( StrEToDouble( value ), aifExp );
               }
               else
               {
                  a = str2atom( value.c_str() );
               }
               break;
            }
            if( !IsNew )
            {
               _var->replaceatom( hPos + hStart, new atom( a ), name.c_str() );
            }
            else
            {
               _var->addatom( new atom( a ), name.c_str() );
            }
         }
      }
   }

   Owner->setActiveObject( this );
}
//---------------------------------------------------------------------------
void TCalcVarList::DeleteVariable( void )
{
   AnsiString name = AnsiString( _var->getAtom( hPos + hStart ).name() );
   
   if( name.UpperCase() != "X" )
   {
      AnsiString msg = "Do you want to delete variable '" + name + "'?";
      int res;
   
      res = ConfirmMsg( msg );
      if( res == mrYes )
      {
         _var->delatom( hPos + hStart );
         if( hPos > 0 )
         {
            hPos--;
         }
         else
         {
            if( hStart > 0 )
            {
               hStart--;
            }
         }
      }
   }
   else
   {
      ErrMsg( "You cannot remove variable 'X'!" );
   }
}
//---------------------------------------------------------------------------
int TCalcVarList::TypeMenu( int CurrentType )
{
   //TCalcObject* oldObj = ActiveObject;
   int j, i, result;
   int types[ 8 ] = { aDouble, aInteger, aComplex, aVector, aMeasure, aExpression, aString, aUnknown };

   //CalcMsg( "Current Type is [" + IntToStr( CurrentType ) + "]" );

   TCalcMenu* mnu = new TCalcMenu( Owner, this );
   mnu->SetCaption( "*** SELECT TYPE ***" );
   mnu->AddItem( "1. REAL", aDouble );
   mnu->AddItem( "2. INTEGER", aInteger );
   mnu->AddItem( "3. COMPLEX", aComplex );
   mnu->AddItem( "4. VECTOR", aVector );
   mnu->AddItem( "5. MEASURED", aMeasure );
   mnu->AddItem( "6. EXPRESSION", aExpression );
   mnu->AddItem( "7. STRING", aString );
   
   if( CurrentType )
   {
      for( j = 0, i = -1; j < 7 && i == -1; j++ )
      {
         if( CurrentType == types[ j ] )
         {            
            mnu->SetDefault( j );
            i = j;
         }
      }
   }
   result = mnu->ShowModal();
   delete mnu;

   Owner->setActiveObject( this );
   return result;
}
//---------------------------------------------------------------------------
int TCalcVarList::ShowModal( void )
{
   #ifdef __WIN32__
	MSG msg;

   Activate();   
   while( !IsClosed() ) // msg.message != WM_QUIT ) //&& Calc.Handle )
   {
      if( GetMessage( &msg, NULL, 0, 0 ) )
      {
            TranslateMessage( &msg );
            DispatchMessage( &msg );
      }
      else
      {
            Close();
      }
   }
	#else
   Calc->setActiveObject( this );

   _result = -1;
   while( !IsClosed() ) //&& !Calc->Terminated() ) // msg.message != WM_QUIT )
   {
      App->processEvents();
   }
   #endif
	
	return _result;
}
//---------------------------------------------------------------------------

