#ifndef _UCALCVAR_H
#define _UCALCVAR_H

#include "ucalcobj.h"
//---------------------------------------------------------------------------
class TCalcVarList : public TCalcObject
{
   private:
   int _result;
   atomlist* _var;
   atomlist* _const;
	atomstack* _stack;
	atominter* _inter;
   int hPos, hStart;
   AnsiString _f6_text;
   
   public:
   TCalcVarList( TCalc* AOwner );
   ~TCalcVarList( void );
   
   void setParentName( AnsiString AName );
   void assignVariables( atomlist* AList );
   void assignConstants( atomlist* AList );
	void assignStack( atomstack* AStack );
	void assignInter( atominter* AItner );
	
   void Refresh( void );
   void Activate( void );
   void ExecAction( TButtonAction& Action );
   
   void EditVariable( bool IsNew );
   void DeleteVariable( void );
   
   int TypeMenu( int CurrentType = 0 );
   
   int ShowModal( void );
};
//---------------------------------------------------------------------------

#endif // _UCALCCONST_H
