#ifndef _UCALCWIN_H
#define _UCALCWIN_H

#include <astrings.h>

#include "ucalcobj.h"

const int 
   btOk        = 0x01,
   btCancel    = 0x02,
   btYes       = 0x04,
   btNo        = 0x08,
   
   btOkCancel      = btOk | btCancel,
   btYesNo         = btYes | btNo,
   btYesNoCancel   = btYes | btNo | btCancel;
   
const int
   mrNone      = 0x00,
   mrCancel    = 0x01,
   mrOk        = 0x02,
   mrYes       = 0x03,
   mrNo        = 0x04;
   
//---------------------------------------------------------------------------
enum TCalcScrollBarStyle { csbVert, cbHoriz };

class TCalcScrollBar 
{
   private:
   TLCDDisplay* _lcd;
   double _min, _max;
   double _pos;
   double _page;
   TCalcScrollBarStyle _style;
   int _left, _top;
   int _width, _height;
   
   public:
   TCalcScrollBar( TLCDDisplay* ALcd = NULL );
   ~TCalcScrollBar();
   
   void SetBounds( int Left, int Top, int Width, int Height );
   void SetLayout( double Min, double Max, double Page );
   void SetPosition( double Pos );
   void SetStyle( TCalcScrollBarStyle Style );
   void Draw( void );
   bool Visible( void ) { return true; }
};
//---------------------------------------------------------------------------
class TCalcWin : public TCalcObject
{
   protected:
   int FLeft, FTop, FWidth, FHeight;
   int FShadow;
   int FButtons;
   AnsiString FCaption;
   bool FInvertCaption;
   bool FCenter;
   //RECT Client;
   
   public:
   TCalcWin( TCalc* AOwner, TCalcObject* AParent = NULL );
   ~TCalcWin();
   
   void SetBounds( int Left, int Top, int Width, int Height );
   void SetShadow( int Shadow );
   void SetCaption( AnsiString ACaption );
   void SetInvertCaption( bool AValue );
   void SetCenter( bool ACentered = true );
   void SetButtons( int AButtons );
   
   virtual void Refresh( void );
   virtual void Activate( void );
   virtual void ExecAction( TButtonAction& Action );
   
   virtual int ShowModal( void );
};
//---------------------------------------------------------------------------
class TCalcMsgBox : public TCalcWin
{
   private:
   AnsiString FMsg;
   TStrings* FStrings;

   void SetMsgLines( void );
   
   public:
   TCalcMsgBox( TCalc* AOwner, TCalcObject* AParent, AnsiString AMsg );
   ~TCalcMsgBox();

   virtual void Refresh( void );
};
//---------------------------------------------------------------------------
void CalcMsg( AnsiString AMessage, AnsiString ACaption = "Message" );
void ErrMsg( AnsiString AMessage, AnsiString ACaption = "*** ERROR ***" );
int ConfirmMsg( AnsiString AMessage, AnsiString ACaption = "*** CONFIRMATION ***" );
//---------------------------------------------------------------------------

#endif // _UCALCWIN_H
