//---------------------------------------------------------------------------

#ifndef uCalcObjH
#define uCalcObjH

#include <stdio.h>
#include <astrings.h>

#include "calctypes.h"
#include "tlcd.h"
#include "uFuncKey.h"

//class TCalc;
//---------------------------------------------------------------------------
class TCalcObject
{
   private:
   bool FClosed;
	bool FModal;
   TFunctionKey Func[ 6 ];
   TFunctionKey OldFunc[ 6 ];
   #ifdef __WIN32__
   HBITMAP hBmp;
   BitmapCanvas* tmpCanvas;
   #else
   #endif
   bool FuncStored;
   AnsiString Name;

   protected:
   TCalcObject* Child;
   TCalcObject* Parent;
   TCalc* Owner;
   TLCDDisplay* LCD;
   bool DisplayClear;
   AnsiString DecSign;
   AnsiString FSeparator;
   TStrings* MenuPos;
   int MenuCmd;
   int MenuWsp;
   int Mode;
   bool IsExecute;
	int Result;

   //void StoreRect( RECT& src );
   //void RestoreRect( RECT& dst );

   public:
   TCalcObject( TCalc* AOwner, TCalcObject* AParent = NULL );
   virtual ~TCalcObject( );



   void SetName( AnsiString AName );
   AnsiString GetName( void );

   bool IsClosed( void );
   bool HasChild( void );
	bool IsModal( void );
	bool IsModalEx( void );
   TCalcObject* GetChild( void );
   void SetChild( TCalcObject* AChild );
   void closeChild( void );
   TLCDDisplay* GetLCD( void );

   virtual void Open( void );
   virtual void Close( void );

   void DefFunc( int FuncNumber, AnsiString Descr, TButtonAction Action );
   void ClearFunc( int FuncNumber );
   void ClearAllFunc( void );
   void StoreFunc( void );
   void RestoreFunc( void );
   TButtonAction GetFunc( int FuncNumber );
   TButtonAction GetFunc( TButtonAction FuncNumber );
   TFunctionKey GetFuncKey( int KeyNum );

   virtual void Refresh( void );
   virtual void Activate( void );
   virtual void InputChar( int Char );
   virtual void ExecAction( TButtonAction& Action );

   virtual void SaveState( FILE* file );
   virtual void LoadState( FILE* file );

   virtual int ShowModal( void );
};
//---------------------------------------------------------------------------
#endif
