/************************* * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2005 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************** * * * * * * * * * * * * **************************/

#ifndef _QHACCCONSTANTS_H
#define _QHACCCONSTANTS_H

#include <qstring.h>
#include <qdatetime.h>

enum ColType { CTNULL, CTSTRING, CTINT, CTUINT, CTFLOAT, CTBOOL, CTDATE };
enum Table { PREFERENCES, JOURNALS, ACCOUNTS, TRANSACTIONS,
						 SPLITS, NAMEDTRANS, JOBS, XTRANS };

class QC {
 public:
	// note: if you change the format of trans, splits, or xtrans,
	// you also need to change the makeXTrans functions in qhacc.cpp
	// trans constants
  static const int TID, TNUM, TPAYEE, TMEMO, TDATE,	TLID, TTYPE, TMETA, TVOID, 
		TCOLS;
	static const char * TCOLNAMES[];
	static const ColType TCOLTYPES[];

	// split constants
  static const int SID, STID, SACCTID, SSUM, SRECO, SRECODATE, SMETA, STAXABLE,
		SCOLS;
	static const char * SCOLNAMES[];
	static const ColType SCOLTYPES[];
	
	// extended transaction constants--a combo of transaction and split info
  static const int XTID, XSID, XSACCTID, XSSUM, XSRECO, XTPAYEE, XTMEMO,
		XTNUM, XTLID, XTDATE, XTTYPE, XSRECODATE, XSMETA, XTMETA, XSTAXABLE, 
		XTVOID, XCOLS;
	static const char * XCOLNAMES[];
	static const ColType XCOLTYPES[];

	// named (memorized) table constants
  static const int NID, NNAME, NTID, NACCTID, NSHORTCUT, NCOLS;
	static const char * NCOLNAMES[];
	static const ColType NCOLTYPES[];

	// account constants
	static const int AINSTNAME, AINSTADDR1, AINSTADDR2, AINSTCITY, AINSTSTATE,
    AINSTZIP, AINSTPHONE, AINSTFAX, AINSTEMAIL, AINSTCONTACT, AINSTNOTES,
		ANAME, ANUM, AOBAL, ACBAL, ATRANSNUMS, ADEFAULTNUM, ATAXED, ACATEGORY,
		ATYPE, APID, ACOLS, AID, ABUDGET, ARBAL, AMETA;
	static const char * ACOLNAMES[];
	static const ColType ACOLTYPES[];
	static const char * ASEP;

	// preferences constants
	static const int PPREF, PVALUE, PCOLS;
	static const char * PCOLNAMES[];
	static const ColType PCOLTYPES[];

	// accounttype constants
	static const uint ASSET, LIABILITY, EQUITY, REVENUE, EXPENSE, NUMTYPES;

	// journal constants
  static const int LID, LNAME, LDESC, LCOLS;
	static const char * LCOLNAMES[];
	static const ColType LCOLTYPES[];

	// jobs constants
  static const int JID, JLASTRUN, JFREQUENCY, JWHAT, JCOLS;
	static const char * JCOLNAMES[];
	static const ColType JCOLTYPES[];

	// plugin preference constants
  static const int IPIPREF, IPIDESCR, IPITYPE, IPILABEL, IPICOLS;
	static const char * IPICOLNAMES[];
	static const ColType IPICOLTYPES[];
	
	// other values
	static const uint YREC, NREC, MREC, REGULAR, MEMORIZED;
	static const int DECIMALS;
	static const int MONTHFREQ, BIMONTHFREQ, ONETIMEFREQ, QUARTERLYFREQ;
	static const int LASTMONTHDAYFREQ;
	static const int AMERICAN, EUROPEAN, YEARFIRST, NEVER, NEW, ALL;

	static const QDate XDATE;

	static const int NUMTABLES;
	static const char * TABLENAMES[], * TCSEP, * REMAINDERVAL;
	static const char * LOANREGEXP, * MARKETREGEXP;
	static const int LOANINT, LOANPMT, LOANNPR; // loan %, payment, # pays left
	// shares, price, and commision of market trans
	static const int MARKETSHARES, MARKETPRICE, MARKETCOMM; 
	static const int TRANT, SPLTT, ACCTT, PREFT, ACTYT, JRNLT, NAMET, JOBST;
};

#endif
