/************************* * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2005 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************* * * * * * * * * * * * * ***************************/

#include "qhaccsegmenter.h"
#include "qhacc.h"
#include "qhacctable.h"

void QHaccSegmenter::segment( const QHacc *, const QHaccResultSet * tbl,
															const QHaccTableIndex * idx,
															uint *& ret, uint& count ){
	// segment the table based on the given index
	// ret is an array of the indicies data starts looking different
	uint rows=tbl->rows();
	if( rows==0 ){
		ret=new uint[1];
		ret[0]=0;
		count=1;
		return;
	}

	int idcol=idx->sorts();

	uint * temp=new uint[rows+1]; // assume everything will be unique
	for( uint i=0; i<rows; i++ ) temp[i]=0;

	TableRow tr=tbl->at( idx->at( rows-1 ) );
	TableCol lastcol=tr[idcol];

	tr=tbl->at( idx->at( 0 ) );
	TableCol checkcol=tr[idcol];

	count=1; // skip 0, because first value in index starts at 0
	while( checkcol!=lastcol ){
		temp[count]=idx->ends( checkcol );
		checkcol=tbl->at( idx->at( temp[count++] ) ).get( idcol );
	}
	temp[count++]=tbl->rows();
	
	// make the returning array
	ret=new uint[count];
	for( uint i=0; i<count; i++ ) ret[i]=temp[i];
	delete [] temp;
}


void QHaccSegmenter::segment( const QHacc *, const QHaccTableIndex * idx,
															const QDate& start, const QDate& end,
															uint *& ret, uint& months ){
	// segment the index in months between start and end
	// ret is an array of the indicies where the differences start
	months=1;
	QDate ndate=start;
	
	if( start<end ){	
		// figure out how many slots we'll need
		while ( ndate<end ){
			months++;
			ndate=ndate.addMonths( 1 );
		}
	}
	ret=new uint[months];

	for( uint i=0; i<months; i++ ){
		ndate=start.addMonths( i );
		if( ndate>end ) ndate=end; // don't go past the end!
		ret[i]=idx->starts( TableCol( ndate ) );
	}
}
