/************************* * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2005 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************** * * * * * * * * * * * * **************************/

#include "tableops.h"

const int TableSelect::EQ=0;
const int TableSelect::NE=1;
const int TableSelect::GT=2;
const int TableSelect::LT=3;
const int TableSelect::GE=4;
const int TableSelect::LE=5;
const int TableSelect::NO=6;
const int TableSelect::ALL=7;

const int TableGet::UQ=0;
/***********************************************************/
/* TABLEGET                                                */
/*   a TableGet is a collection of columns to be returned  */
/*   in a getWhere call to a QHaccTable                    */
/*                                                         */
/***********************************************************/
TableGet::TableGet(){ mod=-1; }
TableGet::TableGet( int i ){
	mod=-1;
	positions.push_back( i );
}

TableGet::TableGet( int i, int j ){
	mod=j;
	positions.push_back( i );
}

TableGet::TableGet( vector<int> poss ){
	mod=-1;
	positions=poss;
}

const TableGet& TableGet::operator=( const TableGet& other ){
	if( &other!=this ){
		mod=other.mod;
		positions=other.positions;
	}
	return *this;
	
}

TableGet::~TableGet(){}

uint TableGet::cnt() const { return positions.size(); }
int TableGet::operator[]( uint i ) const { return positions[i]; }
int TableGet::getMod( uint ) const { return mod; }

/***********************************************************/
/* TABLEUPDATE                                             */
/*   a TableUpdate is a set of PosVals to update once      */
/*   a TableSelect decides which rows have to be updated   */
/*                                                         */
/***********************************************************/

TableUpdate::TableUpdate( int pos, const TableCol& col ){
	changes.push_back( PosVal( pos, col ) );
}

TableUpdate::TableUpdate( vector<PosVal> poss ){ changes=poss; }

TableUpdate::TableUpdate( const TableUpdate& model ){
	if( &model==this ) return;
	changes=model.changes;
}

TableUpdate::~TableUpdate(){}

PosVal TableUpdate::operator[]( uint i ) const { return changes[i]; }
uint TableUpdate::cnt() const { return changes.size(); }

/***********************************************************/
/* TABLESELECT                                             */
/*   a TableSelect is one criteria for selecting from      */
/*   tables. QHaccTable accepts an array of them to make   */
/*   complicated selections on the data in the table       */
/*                                                         */
/***********************************************************/

TableSelect::TableSelect( const TableSelect& other ){
	other.getAll( posval, checktype );
}
TableSelect::TableSelect(){ checktype=ALL; }
TableSelect::TableSelect( int i, const TableCol& col, int ctype ){
	posval=PosVal( i, col );
	checktype=ctype;
}
TableSelect::TableSelect( const PosVal& pv, int ctype ){
	posval=pv;
	checktype=ctype;
}
const TableSelect& TableSelect::operator=( const TableSelect& other ){
	if( &other!=this ) other.getAll( posval, checktype );
	return *this;
}

TableSelect::~TableSelect(){}
void TableSelect::getAll( PosVal& p, int& t ) const {
	p=posval;
	t=checktype;
}

QString TableSelect::toString() const {
	int column;
	TableCol model;
	posval.get( column, model );

	QString temp=QString().setNum( column );
	QString ret="selector for: "+temp+" "+model.gets()+" ";
	
	if( checktype==ALL ) temp="ALL";
	else if( checktype==EQ ) temp="EQ";
	else if( checktype==NE ) temp="NE";
	else if( checktype==GT ) temp="GT";
	else if( checktype==GE ) temp="GE";
	else if( checktype==LT ) temp="LT";
	else if( checktype==LE ) temp="LE";
	else temp="NO";
	return ret+=temp;
}

QString TableSelect::sqlSel() const {
	QString temp;

	if( checktype==EQ ) temp="=";
	else if( checktype==NE ) temp="!=";
	else if( checktype==GT ) temp=">";
	else if( checktype==GE ) temp=">=";
	else if( checktype==LT ) temp="<";
	else if( checktype==LE ) temp="<=";
	else{
		if( checktype==ALL ) temp="ALL";
		else temp="NO";
		return temp+" is not a SQL selector";
	}
	return temp;
}

int TableSelect::check() const { return checktype; }
int TableSelect::column() const { return posval.getp(); }
TableCol TableSelect::model() const { return posval.getv(); }

bool TableSelect::check( const TableRow& row, ColType ct ) const {
	if( checktype==ALL ) return true;
	else if ( checktype==NO ) return false;
	int result=row[column()].compareTo( model(), ct );

	if( result==0 )	return ( checktype==EQ || checktype==GE || checktype==LE );
	else if( result<0 ) return ( checktype==NE || checktype==LT ||
															 checktype==LE );
	else return ( checktype==NE || checktype==GT || checktype==GE );
}

bool TableSelect::sqlValid() const {
	return ( !( checktype==ALL || checktype==NO ) );
}

