/************************* * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2005 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************** * * * * * * * * * * * * **************************/

#ifndef CLIIMPORTER_H
#define CLIIMPORTER_H

#include "plugins.h"
#include "plugininfo.h"

class QHaccTable;

class CLIInfo : public PluginInfo {
 public:
	CLIInfo();
};

class CLIImporter : public QHaccIOPlugin {
 public:
	static const CLIInfo pinfo;
	CLIImporter();
	virtual ~CLIImporter();

	const PluginInfo& info() const;

	virtual bool connect( QHacc * eng, const QString& home, QString& error );
	virtual bool load( QString& error );
	virtual bool exprt( QHaccResultSet * );

	virtual bool imprt( QHaccResultSet * );
	virtual bool save( QString& );

 protected:
	QHacc * engine;
	QString home;
	
	bool checkHelp( int, int, const QString& ) const;
	bool unmanned( const QString& home, QString& err );
	bool manned( QString& err );
};

#endif
