/************************* * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2005 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************** * * * * * * * * * * * * **************************/

#include "extprgplugin.h"

#include <stdlib.h>

// plugin factory calls
extern "C" {
	QHaccPlugin * create(){	return new EXTPRGDBPlugin; }
	void destroy( EXTPRGDBPlugin * p ){ delete p; }
}

const EXTPRGInfo EXTPRGDBPlugin::pinfo;

EXTPRGDBPlugin::EXTPRGDBPlugin() : LocalFileDBPlugin(){}
EXTPRGDBPlugin::~EXTPRGDBPlugin(){}

const PluginInfo& EXTPRGDBPlugin::info() const { return pinfo; }

bool EXTPRGDBPlugin::iload( QString& err ){ 
	// QHACC_HOME is EXTPRG:QHACC_HOME:command
	
	// load the files by running "command load QHACC_HOME"
	// then load the files using LocalDBPlugin
	
	homer( home, cmd );
	int i=system( cmd+" load "+home );
	if( i==0 ) return LocalFileDBPlugin::iload( err );
	else{
		err="could not call external program: "+cmd;
		return false;
	}
}

bool EXTPRGDBPlugin::save( QString& err ){
	// save the files using LocalDBPlugin, then run "command save QHACC_HOME"

	bool ret=LocalFileDBPlugin::save( err );
	if( ret ){
		// QHACC_HOME is EXTPRG:QHACC_HOME:command
		ret=( system( cmd+" save "+home )==0 );
	}
	return ret;
}

void EXTPRGDBPlugin::homer( QString& home, QString& cmd ){
	// the QHACC_HOME passed in is EXTPRG:QHACC_HOME:command
	// but the engine removes the EXTPRG:. Get the home and the command
	QString qh( home );
	int finder=qh.find( ":" );
	home=qh.left( finder );
	cmd=qh.mid( finder+1 );
}

EXTPRGInfo::EXTPRGInfo(){
	description="External Program";
	stubby="EXTPRG";
	targ=ANY;
}
