/************************* * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2005 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************** * * * * * * * * * * * * **************************/

#include "genplugin.h"
#include "localfileplugin.h"
#include "qhacctable.h"
#include "qhaccutils.h"
#include "qhacc.h"

#include <qregexp.h>

#include <stdlib.h> // for rand calls

// plugin factory calls
extern "C" {
	QHaccPlugin * create(){	return new GenExporter; }
	void destroy( GenExporter * p ){ delete p; }
}

const GenInfo GenExporter::pinfo;

GenExporter::GenExporter(){ data=0; }

GenExporter::~GenExporter(){ if( data ) delete [] data; }

bool GenExporter::save( QString& err ){
	bool good=true;
	LocalFileDBPlugin lf;
	good=( lf.connect( engine, home, err ) &&
				 lf.imprt( data ) && lf.save( err ) );
  return good;
}

bool GenExporter::connect( QHacc* e, const	QString& h, QString& err ){
	engine=e;
	// the QHACC_HOME we want is GEN:<# trans>:<time span>:<target directory>
	QRegExp reg( "(\\d+):(\\d+):(.*)" );
	bool good=( reg.search( h )!=-1 );
	if( good ){
		numtrans=reg.cap( 1 ).toInt();
		timespan=reg.cap( 2 ).toInt();
		home=reg.cap( 3 );
		data=new QHaccResultSet[QC::NUMTABLES];
	}
	else{
		err="could not parse QHACC_HOME: "+h;
		good=false;
	}
	return good;
}

bool GenExporter::load( QString& ){ return false; }
bool GenExporter::exprt( QHaccResultSet* ){ return false; }
bool GenExporter::imprt( QHaccResultSet * rss ){ 
	const MonCon& conv=engine->converter();

	for( int i=0; i<QC::NUMTABLES; i++ ) {
		Table t=( Table )i;
		data[i]=QHaccResultSet( Utils::tcols( t ), Utils::ttypes( t ) );
	}

	// we'll make random data, but based on the currently-imported data

	// first, non-incriminating journals and prefs
	data[QC::JRNLT].load( &rss[QC::JRNLT] );
	uint pr=rss[QC::PREFT].rows();
	for( uint i=0; i<pr; i++ ){
		if( !rss[QC::PREFT][i][QC::PPREF].gets().startsWith( "CHOOSERBOX" ) ){
			data[QC::PREFT]+=rss[QC::PREFT][i];
		}
	}
	

	
	// copy only unimportant account information
	int ngets=8;
	int gets[]={ QC::AID, QC::ANAME, QC::ATYPE, QC::APID, QC::ATYPE,
							 QC::ATRANSNUMS, QC::ADEFAULTNUM, QC::ACATEGORY };
	QHaccTable tbl( rss[QC::ACCTT] );
	uint rr=tbl.rows();

	TableRow row( QC::ACOLS );
	for( uint i=0; i<rr; i++ ){
		for( int j=0; j<ngets; j++ ) row.set( gets[j], tbl[i][gets[j]] );
		data[QC::ACCTT]+=row;
	}

	
	// now, start making some transactions
	bool de=engine->getBP( "DOUBLEENTRY" );
	// don't allow double-entry transactions if we don't have enough accounts
	if( de && data[QC::ACCTT].rows()==1 ) de=false;

	// use the current list of payees, or if
	// that doesn't exist, just make some up
	QString * payees=0;
	uint numpayees=0;
	if( rss[QC::TRANT].rows()>0 ){
		vector<TableSelect> v;
		auto_ptr<QHaccResultSet> temp=engine->getWhere( TRANSACTIONS,
																										TableGet( QC::TPAYEE, 
																															TableGet::UQ ),
																										v, numpayees );
		payees=new QString[numpayees];
		for( uint i=0; i<numpayees; i++ ) payees[i]=temp->at( i )[0].gets();
	}
	else{
		numpayees=5;
		payees=new QString[numpayees];
		for( uint i=0; i<numpayees; i++ ) payees[i]="payee "+QString().setNum( i );
	}

	TableCol lid=rss[QC::JRNLT][0][QC::LID];
	Transaction trans( QC::TCOLS );
	Split split1( QC::SCOLS ), split2( QC::SCOLS );

	for( int i=1; i<numtrans+1; i++ ){
		trans.set( QC::TID, i );
		trans.set( QC::TPAYEE, payees[rand()%numpayees] );
		trans.set( QC::TDATE, QDate::currentDate().addDays( -rand()%timespan ) );
		trans.set( QC::TNUM, i );
		trans.set( QC::TLID, lid );
		trans.set( QC::TTYPE, QC::REGULAR );
		trans.set( QC::TVOID, false );
		data[QC::TRANT]+=trans;

		int isum=rand()/10000;
		QString sum=conv.convert( isum, Engine, Engine );

		split1.set( QC::SID, i );
		split1.set( QC::STID, i );
		split1.set( QC::SSUM, sum );
		split1.set( QC::SRECODATE, QC::XDATE );
		split1.set( QC::SRECO, QC::NREC );
		uint ra=rand()%( rr-1 )+1;
		split1.set( QC::SACCTID, data[QC::ACCTT][ra][QC::AID] );

		data[QC::SPLTT]+=split1;
		if( de ){
			split2.set( QC::STID, i );
			split2.set( QC::SID, i+numtrans );
			split2.set( QC::SSUM, "-"+sum );
			split2.set( QC::SRECODATE, QC::XDATE );
			split2.set( QC::SRECO, QC::NREC );
			uint ra2=rand()%( rr-1 )+1;
			// don't get the same account as split1
			while( ra2==ra ) ra2=rand()%( rr-1 )+1;
			split2.set( QC::SACCTID, data[QC::ACCTT][ra2][QC::AID] );
			data[QC::SPLTT]+=split2;
		}
	}
	

	delete [] payees;
	return true; 
}

const PluginInfo& GenExporter::info() const { return pinfo; }

GenInfo::GenInfo(){
	targ=DIRECTORY;
	stubby="GEN";
	description="Random Data Generator";
	guisel=false;
}
