/************************* * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2005 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************** * * * * * * * * * * * * **************************/

#ifndef GENEXPORTER_H
#define GENEXPORTER_H

#include "plugins.h"
#include "plugininfo.h"
#include "qhacctablerows.h"

class GenInfo : public PluginInfo {
 public:
	GenInfo();
};

class GenExporter : public QHaccIOPlugin {
 public:
	static const GenInfo pinfo;

	GenExporter();
	virtual ~GenExporter();

	virtual bool save( QString& );
	
	const PluginInfo& info() const;
	
	bool connect( QHacc* e, const	QString&, QString& );
	bool load( QString& );
	bool exprt( QHaccResultSet* );
	bool imprt( QHaccResultSet* );
	bool rawloader() const;

 protected:
	QHacc * engine;
	QString home;
	QHaccResultSet * data;
	int timespan, numtrans;
};

#endif
