/************************* * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2005 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************** * * * * * * * * * * * * **************************/

#include "grapher.h"
#include "qhacc.h"
#include "qhacctable.h"
#include "qhaccconstants.h"

#include <qpixmap.h>
#include <qpainter.h>

const QString GraphBase::EMPTYSTR=QT_TR_NOOP( "No Transactions" );

GraphBase::GraphBase(){
	colors=new QColor[0];
	accounts=0;
	data=0;
}

GraphBase::~GraphBase(){
	if( accounts ) delete accounts;
	delete [] colors;
}

void GraphBase::setup( QHacc * e ){
	delete accounts;

	engine=e;
	accounts=new QHaccTable( QC::ACOLS, QC::ACOLTYPES );
	accounts->setPK( QC::AID );
	
	baseline=zeroline=0;
	data=0;
  // get some random colors to draw into graphs
  // i picked 12 so a big graph will repeat colors every year
  // it's neccessary to keep track of these colors because
  // partial repaints will look very bad otherwise  
  colors=new QColor[12];
  for ( int i=0; i<12; i++ )
    colors[i]=QColor( rand()%100+150, rand()%100+150, rand()%100+150 );
}

void GraphBase::setData( uint lid, const QHaccResultSet& accts,
																 const QDate& s, const QDate& e ){
	journalid=lid;
	accounts->clear();
	accounts->load( &accts );
	start=s;
	end=e;
	isetData();
}

void GraphBase::mouseDates( const QPoint&, QDate& st,
																		QDate& en ) const {
	st=start;
	en=end;
}

vector<TableSelect> GraphBase::describeMouse( const QPoint& p ) const {
	// return selection criteria for XTRANS to describe this mouse point
	QDate st, en;
	mouseDates( p, st, en );
	
	vector<TableSelect> ret;
	TableSelect ts=mouseSel( p );

	// make sure we select at least one account
	// NO! Pie graphs might not return an account return 
	//if( ts.column()!=QC::XSACCTID && accounts->rows()==1 )
	//ret.push_back( TableSelect( QC::XSACCTID, accounts->at( 0 )[QC::AID] ) );

	ret.push_back( ts );
	ret.push_back( TableSelect( QC::XTDATE, TableCol( st ), TableSelect::GE ) );
	ret.push_back( TableSelect( QC::XTDATE, TableCol( en ), TableSelect::LE ) );
	ret.push_back( TableSelect( QC::XTTYPE, TableCol( QC::REGULAR ) ) );
	

	return ret;
}

void GraphBase::painted( const QPixmap& ){}
void GraphBase::paint( QPainter * p, const QRect& size ){
	QPixmap pix( size.width(), size.height() );
	QPainter painter( &pix );
	painter.fillRect( pix.rect(), engine->getCP( "MAINCOLOR" ) );
	paintBase( &painter, size );
	paintMain( &painter, size );
	p->drawPixmap( size.left(), size.top(), pix );
	painted( pix );
}


/********************/
/*****Plugin Info****/
/********************/

GraphInfo::GraphInfo(){
	piprefs.reset( new QHaccResultSet( QC::IPICOLS, QC::IPICOLTYPES ) );
	TableRow row( QC::IPICOLS );
	row.set( QC::IPITYPE, CTBOOL );

	const int NPREFS=4;
	const char * HS[]={ QT_TR_NOOP( "Show Names in Multi-Account Graphs" ),
											QT_TR_NOOP( "Draw Guidelines" ), 
											QT_TR_NOOP( "Show Totals Above Graph Values" ), 
											QT_TR_NOOP( "Bar and Line Graphs Display Deltas, Not Totals" ) };
	const char * CS[]={ "GRAPHHEADS", "GRAPHGUIDES", "GRAPHSHOWTOTALS",
											"GRAPHDELTAS" };
	for( int i=0; i<NPREFS; i++ ){
		row.set( QC::IPIPREF, CS[i] );
		row.set( QC::IPILABEL, HS[i] );
		
		piprefs->add( row );
	}

	atom=raw=false;
	guisel=true;
	targ=NONE;
}

DoubleBarInfo::DoubleBarInfo(){
	description="Two Bar";
	stubby="TWOBAR";
}

SingleBarInfo::SingleBarInfo(){
	description="Bar";
	stubby="ONEBAR";
}

DoubleLineInfo::DoubleLineInfo(){
	description="Two Line";
	stubby="TWOLINE";
}

SingleLineInfo::SingleLineInfo(){
	description="Line";
	stubby="ONELINE";
}

PieInfo::PieInfo(){
	description="Pie Chart";
	stubby="PIE";

	piprefs.reset( new QHaccResultSet( QC::IPICOLS, QC::IPICOLTYPES ) );
	TableRow row( QC::IPICOLS );
	row.set( QC::IPITYPE, CTBOOL );
	
	
	const int NPREFS=3;
	const char * HS[]={ QT_TR_NOOP( "Sort Double-Entry Pie Graphs on Payee" ),
											QT_TR_NOOP( "Pie Graphs Include Credits" ),
											QT_TR_NOOP( "Pie Graphs Include Debits" ) };
	const char * CS[]={ "GRAPHPIEPAYEES", "GRAPHPIECREDITS", "GRAPHPIEDEBITS"	};

	for( int i=0; i<NPREFS; i++ ){
		row.set( QC::IPIPREF, CS[i] );
		row.set( QC::IPILABEL, HS[i] );
		
		piprefs->add( row );
	}
	
	row.set( QC::IPITYPE, CTFLOAT );
	row.set( QC::IPIPREF, "MERGEPCT" );
	row.set( QC::IPILABEL,  QT_TR_NOOP( "Pie Graph Merge %" ) );
	piprefs->add( row );
}

