/************************** * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2005 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************** * * * * * * * * * * * * ***************************/

#ifndef _MGRAPHER_H
#define _MGRAPHER_H

#include "grapher.h"

class QHacc;
class QPainter;
class TableRow;
class QHaccTable;
class QHaccTableIndex;

class MonthlyGraph : public GraphBase {
 public:
	static const uint AID, NUMBER, INCREASES, DECREASES;

	MonthlyGraph();
	~MonthlyGraph();
	
	virtual void setup( QHacc * e );

 protected:
	void setLine( bool );
	void setIvsE( bool );
	void paintBase( QPainter *, const QRect& );
	void paintMain( QPainter *, const QRect& );
	TableSelect mouseSel( const QPoint& ) const;
	void mouseDates( const QPoint&, QDate& s, QDate& e ) const;
	void isetData();
	void drawSum( QPainter *, int sum, int, int, int, int ) const;
	void drawTitle( QPainter *, const QString&, int wstart, int wspot,
									int hspot ) const;

	virtual void paintRow( QPainter *, const TableRow& last, const TableRow&,
												 int wstart, int wspot, const QColor&, bool,
												 const QString& ) const =0;

	bool line, ivse;
	QString * monthstrs;
	uint months, wpm, wpa; //widthpermonth, widthperaccount
	float hiVal, loVal, factor;
};

#endif
