/************************** * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2005 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************** * * * * * * * * * * * * ***************************/

#ifndef _PIEGRAPHER_H
#define _PIEGRAPHER_H

#include "grapher.h"

#include <qimage.h>

class MonCon;
class QHaccTableIndex;

class PieGraph : public GraphBase {
 public:
	static const PieInfo pinfo;

	PieGraph();
	~PieGraph();

	const PluginInfo& info() const;

	void setup( QHacc * );

 protected:
	void paintBase( QPainter *, const QRect& );
	void paintMain( QPainter *, const QRect& );
	void painted( const QPixmap& );
	TableSelect mouseSel( const QPoint& ) const;
	void isetData();

 private:
	static const uint TITLE, TOTAL, MERGED, MERGEROWS;
	
	QHaccTableIndex * summer;
	QImage image;
	QColor * refColors;
	auto_ptr<MonCon> conv;
};

#endif
