/************************* * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2005 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************* * * * * * * * * * * * * ***************************/

#include "singlebargraph.h"
#include "qhacctable.h"
#include "qhacc.h"

#include <qpainter.h>

// plugin factory calls
extern "C" {
	QHaccPlugin * create(){	return new SingleBarGraph; }
	void destroy( SingleBarGraph * p ){ delete p; }
}

SingleBarGraph::SingleBarGraph(){
	setIvsE( false );
	setLine( false );
}

SingleBarGraph::~SingleBarGraph(){}
void SingleBarGraph::paintRow( QPainter * p, const TableRow&, 
																const TableRow& row, int wstart,
																int wspot, const QColor& color,	bool drawTots, 
																const QString& head ) const {
	//cout<<"PAINTROW\t"<<row->toString()<<"\t";
	//if( last ) cout<<last->toString();
	//else cout<<"no last row";
	//cout<<endl;
	
	int sum=row.geti( INCREASES )+row.geti( DECREASES );
	int hpos=zeroline-( int )( sum/factor );
	int sstart=wstart, send=wpm;
	int tstart=wstart;
	//p->setPen( QPen( color ) );
	//cout<<"  point is ("<<wpos<<","<<hpos<<")..."<<sum<<"*"<<factor<<"="<<sum*factor<<endl;

	sstart=wspot;
	send=wpa;
	QRect rect( wspot, hpos, wpa, zeroline-hpos );
	QColor col;
	if( col==INCREASES ) col=color.light( 110 );
	else col=color.dark( 115 );
	
	p->fillRect( rect, QBrush( col ) );
	p->setPen( QPen( "black" ) );
	p->drawRect( rect );
	
	if( !head.isNull() ) drawTitle( p, head, sstart, tstart, hpos );	

	if( drawTots )
		drawSum( p, sum, sstart, hpos, send, p->fontMetrics().height() );
}

const SingleBarInfo SingleBarGraph::pinfo;
const PluginInfo& SingleBarGraph::info() const { return pinfo; }
