/************************* * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2005 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************** * * * * * * * * * * * * **************************/

#ifndef OFXIMPORTER_H
#define OFXIMPORTER_H

#include "plugins.h"
#include "plugininfo.h"
#include "qhacctablerows.h"

#include <libofx.h>
using namespace std;

class QHaccTable;

class OFXInfo : public PluginInfo {
 public:
	OFXInfo();
};

class OFXImporter : public QHaccIOPlugin {
 public:
	static const OFXInfo pinfo;

	OFXImporter();
	virtual ~OFXImporter();

	const PluginInfo& info() const;

	virtual bool connect( QHacc * eng, const QString& home, QString& error );
	virtual bool load( QString& error );
	virtual bool exprt( QHaccResultSet * );

	virtual bool imprt( QHaccResultSet * );
	virtual bool save( QString& );

	TableRow handleA( const struct OfxAccountData );
	void handleT( const struct OfxTransactionData );

 protected:
	QHacc * engine;
	QString home;
	QHaccTable * transactions, * accounts, * splits;
	TableRow journal;

	static int ofx_statement_cb( const struct OfxStatementData, void * );
	static int ofx_account_cb( const struct OfxAccountData, void * );
	static int ofx_transaction_cb( const struct OfxTransactionData, void * );
	static int ofx_security_cb( const struct OfxSecurityData, void * );
	static int ofx_status_cb( const struct OfxStatusData, void * );
};

#endif
