/************************* * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2005 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************** * * * * * * * * * * * * **************************/

#include "acctreport.h"
#include "qhacc.h"
#include "qhaccutils.h"
#include "qhacctable.h"
#include "qhaccsegmenter.h"

#include <stdlib.h>

// plugin factory calls
extern "C" {
	QHaccPlugin * create(){	return new AccountsReport; }
	void destroy( AccountsReport * p ){ delete p; }
}

AccountsReport::AccountsReport(){}
AccountsReport::~AccountsReport(){}

auto_ptr<QHaccResultSet> AccountsReport::generate( uint jid,
																									 QHaccResultSet *,
																									 const QDate& start,
																									 const QDate&  end,
																									 QString& title ){
	auto_ptr<QHaccResultSet> accts=engine->getAs( TableGet() );
	title=titler( accts.get(), jid, start, end );
	return igen( gentrans( accts.get(), jid, start, end ) );
}

auto_ptr<QHaccResultSet> AccountsReport::generate( QHaccResultSet *,
																									vector<TableSelect> ss,
																									QString& title ){
	auto_ptr<QHaccResultSet> accts=engine->getAs( TableGet() );
	title=titler( accts.get() );
	return igen( gentrans( accts.get(), ss ) );
}

QString AccountsReport::description() const { return sdescription(); }
QString AccountsReport::sdescription() { return "Accounts"; }

QString AccountsReport::understands() const { return sunderstands(); }
QString AccountsReport::sunderstands() { return "ACCT"; }

bool AccountsReport::homeok( const QString&, uint&,	auto_ptr<QHaccResultSet>&,
														 QDate& start, QDate& stop, QString& ){
	start=engine->min( TRANSACTIONS, QC::TDATE ).getd();
	stop=QDate::currentDate();
	return true;
}

auto_ptr<QHaccResultSet> AccountsReport::igen( auto_ptr<QHaccResultSet> data ){
	// data contains basically every transaction in the database.
	// group the based on SACCTID
	const MonCon& conv=engine->converter();
	auto_ptr<QHaccResultSet> ret( new QHaccResultSet( 1 ) );

	uint * pos=0, sz=0;
	QHaccTableIndex idx( data.get(), QC::XSACCTID, CTUINT );
	QHaccSegmenter::segment( engine, data.get(), &idx, pos, sz );

	ret->startLoad( sz-1 );
	for( uint i=0; i<sz-1; i++ ){
		// for each account's transactions, make a sum and a count
		uint tcnt=pos[i+1]-pos[i];
		QString line;
		
		uint j=pos[i];
		Transaction xt=data->at( idx[j++] );
		int sum=conv.converti( xt[QC::XSSUM].gets(), Engine, Engine );
		for( ; j<pos[i+1]; j++ ){
			xt=data->at( idx[j] );
			sum+=conv.converti( xt[QC::XSSUM].gets(), Engine, Engine );
		}
		
		uint aid=xt[QC::XSACCTID].getu();
		line=QString().setNum( aid )+":"+engine->getFNameOfA( aid )+": "+
			conv.convert( sum )+" in "+QString().setNum( tcnt )+
			( tcnt==1 ? " transaction" : " transactions" )+QString( "; current balance is " )+conv.convert( engine->getA( aid )[QC::ACBAL].gets() );
		
		TableRow row( 1 );
		row.set( 0, line );
		ret->add( row );	
	}
	ret->stopLoad();
	return ret;
}

QString AccountsReport::writereport( const QString& title,
																		 const QHaccResultSet * data ){
	QString ret=title;
	if( data->isEmpty() ) ret.append( "\n\tNo Transactions" );
	else{
		for( uint i=0; i<data->rows(); i++ ) ret+="\n"+data->at( i )[0].gets();
	}
	return ret;
}

void AccountsReport::selected( QDate&, QDate&, bool& enableacctsel,
															 bool& enablemultiselect ){
	enablemultiselect=enableacctsel=false;
}

const AccountsInfo AccountsReport::pinfo;
const PluginInfo& AccountsReport::info() const { return pinfo; }

