/************************* * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2005 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************** * * * * * * * * * * * * **************************/

#include "breport.h"
#include "qhacc.h"
#include "qhaccutils.h"
#include "qhacctable.h"
#include "qhaccsegmenter.h"

#include <stdlib.h>

// plugin factory calls
extern "C" {
	QHaccPlugin * create(){	return new BalancesReport; }
	void destroy( BalancesReport * p ){ delete p; }
}

BalancesReport::BalancesReport(){}
BalancesReport::~BalancesReport(){}

auto_ptr<QHaccResultSet> BalancesReport::generate( uint jid,
																									 QHaccResultSet * accounts,
																									 const QDate& start,
																									 const QDate&  end,
																									 QString& title ){
	title=titler( accounts, jid, start, end );
	return igen( accounts, gentrans( accounts, jid, start, end ), start, end );
}

auto_ptr<QHaccResultSet> BalancesReport::generate( QHaccResultSet * accts,
																									 vector<TableSelect> s,
																									 QString& title ){
	title=titler( accts );
	return igen( accts, gentrans( accts, s ) );
}

auto_ptr<QHaccResultSet> BalancesReport::igen( QHaccResultSet * accts,
																							 auto_ptr<QHaccResultSet> data,
																							 QDate start, QDate end ){

	const MonCon& conv=engine->converter();

	QHaccTableIndex idx( data.get(), QC::XTDATE, CTDATE );
	if( data->rows()>0 && !start.isValid() ){
		start=idx.min().getd();
		end=idx.max().getd();
	}

	// segment based on date (monthly)
	uint * pos=0, sz=0;
	QHaccSegmenter::segment( engine, &idx, start, end, pos, sz );

	// include sub accounts in account balances?
	bool rollups=engine->getBP( "INCLUDESUBSONRECALC" );
		
	// opening balance will be the combined balance of all accounts
	int startSum=0;
	uint arows=accts->rows();
	for( uint i=0; i<arows; i++ ){
		const Account& a=accts->at( i );
		startSum+=engine->getABalOn( a, start, TableSelect() );

		if( rollups ){
			uint rr=0;
			vector<TableSelect> vs( 1, TableSelect( QC::APID, a[QC::AID] ) );
			
			auto_ptr<QHaccResultSet> cs=engine->getWhere( ACCOUNTS,	vs,	rr );
			for( uint j=0; j<rr; j++ ){
				startSum+=engine->getABalOn( cs->at( j ), start, TableSelect() );
			}
		}		
	}

	auto_ptr<QHaccResultSet>ret( new QHaccResultSet( 2 ) );
	ret->startLoad( sz-1 );
	QDate ndate=start;

	QString sep=engine->getSP( "DATESEPARATOR" );
	int fmt=engine->getIP( "DATEFORMAT" );

	for( uint i=0; i<sz-1; i++ ){
		QString head=Utils::shortStringFromDate( ndate, sep, fmt );
		head.append( "-" );
		
		ndate=ndate.addMonths( 1 );
		ndate=ndate.addDays( -1 );
		if( ndate>end ) ndate=end;
		head.append( Utils::shortStringFromDate( ndate, sep, fmt ) );
		ndate=ndate.addDays( 1 );
		TableCol month( head );
		int sum=startSum;
		
		for( uint j=pos[i]; j<pos[i+1]; j++ )
			sum+=conv.converti( data->at( idx[j] )[QC::XSSUM].gets(),
													Engine, Engine );
		
		TableCol cols[]={ month, TableCol( conv.convert( sum ) ) };
		ret->add( TableRow( cols, 2 ) );
		startSum=sum;
	}
	ret->stopLoad();
	return ret;
}

const BalancesInfo BalancesReport::pinfo;
const PluginInfo& BalancesReport::info() const { return pinfo; }
