/************************* * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2005 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************** * * * * * * * * * * * * **************************/

#include "dreport.h"
#include "qhacc.h"
#include "qhaccutils.h"
#include "qhacctable.h"
#include "qhaccsegmenter.h"

#include <stdlib.h>

// plugin factory calls
extern "C" {
	QHaccPlugin * create(){	return new DeltasReport; }
	void destroy( DeltasReport * p ){ delete p; }
}

DeltasReport::DeltasReport(){}
DeltasReport::~DeltasReport(){}

auto_ptr<QHaccResultSet> DeltasReport::generate( uint jid,
																								 QHaccResultSet * accounts,
																								 const QDate& start,
																								 const QDate&  end,
																								 QString& title ){
	title=titler( accounts, jid, start, end );
	return igen( gentrans( accounts, jid, start, end ), start, end );
}

auto_ptr<QHaccResultSet> DeltasReport::generate( QHaccResultSet * accts,
																								 vector<TableSelect> s,
																								 QString& title ){
	title=titler( accts );
	return igen( gentrans( accts, s ) );
}

auto_ptr<QHaccResultSet> DeltasReport::igen( auto_ptr<QHaccResultSet> data,
																						 QDate start, QDate end ){
	
	const MonCon& conv=engine->converter();

	QHaccTableIndex idx( data.get(), QC::XTDATE, CTDATE );
	if( data->rows()>0 && !start.isValid() ){
		start=idx.min().getd();
		end=idx.max().getd();
	}

	// segment based on date (monthly)
	uint * pos=0, sz=0;
	QHaccSegmenter::segment( engine, &idx, start, end, pos, sz );
		
	// opening balance will be the combined balance of all accounts
	auto_ptr<QHaccResultSet>ret( new QHaccResultSet( 4 ) );
	QDate ndate=start;

	QString sep=engine->getSP( "DATESEPARATOR" );
	int fmt=engine->getIP( "DATEFORMAT" );

	for( uint i=0; i<sz-1; i++ ){
		QString head=Utils::shortStringFromDate( ndate, sep, fmt );
		head.append( "-" );
		
		ndate=ndate.addMonths( 1 );
		ndate=ndate.addDays( -1 );
		if( ndate>end ) ndate=end;
		head.append( Utils::shortStringFromDate( ndate, sep, fmt ) );
		ndate=ndate.addDays( 1 );
		TableCol month( head );
		int sum=0, credits=0, debits=0;

		for( uint j=pos[i]; j<pos[i+1]; j++ ){
			int tsum=conv.converti( data->at( idx[j] )[QC::XSSUM].gets(),
															Engine, Engine );
			sum+=tsum;
			if( tsum>0 ) credits+=tsum;
			else debits+=tsum;
		}

		TableCol cols[]={ month, TableCol( conv.convert( credits ) ),
											TableCol( conv.convert( debits ) ),
											TableCol( conv.convert( sum ) ) };
		ret->add( TableRow( cols, 4 ) );
	}
	
	return ret;
}

const DeltasInfo DeltasReport::pinfo;
const PluginInfo& DeltasReport::info() const { return pinfo; }
