/************************* * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2005 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************** * * * * * * * * * * * * **************************/

#include "tbalreport.h"
#include "qhacc.h"
#include "qhaccutils.h"
#include "qhacctable.h"
#include "qhaccsegmenter.h"

#include <stdlib.h>

// plugin factory calls
extern "C" {
	QHaccPlugin * create(){	return new TransBalReport; }
	void destroy( TransBalReport * p ){ delete p; }
}

TransBalReport::TransBalReport(){}
TransBalReport::~TransBalReport(){}

auto_ptr<QHaccResultSet> TransBalReport::generate( uint jid,
																									 QHaccResultSet * accts,
																									 const QDate& start,
																									 const QDate&  end,
																									 QString& title ){
	title=titler( accts, jid, start, end );
	return igen( gentrans( accts, jid, start, end ) );
}

auto_ptr<QHaccResultSet> TransBalReport::generate( QHaccResultSet * accts,
																									vector<TableSelect> ss,
																									QString& title ){
	title=titler( accts );
	return igen( gentrans( accts, ss ) );
}

auto_ptr<QHaccResultSet> TransBalReport::igen( auto_ptr<QHaccResultSet> data ){
	const MonCon& conv=engine->converter();

	auto_ptr<QHaccResultSet> ret( new QHaccResultSet( 1 ) );
	TableRow line( 1 );

	QHaccTableIndex index( data.get(), QC::XTDATE, CTDATE, QC::XSID, CTUINT );
	uint rr=data->rows();

	if( rr>0 ){
		QString sep=engine->getSP( "DATESEPARATOR" );
		int fmt=engine->getIP( "DATEFORMAT" );
		bool rollups=engine->getBP( "INCLUDESUBSONRECALC" );

		Account acct=engine->getA( data->at( 0 )[QC::XSACCTID].getu() );
		QDate start=index.min().getd();
		int acctbal=engine->getABalOn( acct, start, TableSelect() );
		if( rollups ){
			uint rr=0;
			vector<TableSelect> vs( 1, TableSelect( QC::APID, acct[QC::AID] ) );
			
			auto_ptr<QHaccResultSet> cs=engine->getWhere( ACCOUNTS,	vs,	rr );
			for( uint j=0; j<rr; j++ ){
				acctbal+=engine->getABalOn( cs->at( j ), start, TableSelect() );
			}
		}

		QString head=QString( "%1 %2 %3 %4 %5 %6" ).arg( "Num", 5 ).arg( "Date", -10 ).arg( "Payee", -25 ).arg( "Memo", -15 ).arg( "Sum", 10 ).arg( "Balance", 10 );
		line.set( 0, head );
		ret->add( line );


		QString line1=QString( "%1 %2 %3 %4 %5 %6" ).arg( "", 5 ).arg( Utils::stringFromDate( start, sep, fmt ), -10 ).arg( "Opening Balance", -25 ).arg( "", -15 ).arg( "", 10 ).arg( conv.convert( acctbal ), 10 );
		line.set( 0, line1 );
		ret->add( line );

		ret->startLoad( rr );
		for( uint i=0; i<rr; i++ ){
			const Transaction& row=data->at( index[i] );
			
			const QString& num=row[QC::XTNUM].gets().left( 5 );
			const QString& date=Utils::stringFromDate( row[QC::XTDATE].getd(),
																								 sep, fmt );
			const QString& payee=row[QC::XTPAYEE].gets().left( 25 );
			const QString& memo=row[QC::XTMEMO].gets().left( 15 );
			const QString& sum=row[QC::XSSUM].gets();

			acctbal+=conv.converti( sum, Engine, Engine );

			QString str=QString( "%1 %2 %3 %4 %5 %6" ).arg( num, 5 ).arg( date, -10 ).arg( payee, -25 ).arg( memo, -15 ).arg( conv.convert( sum ), 10 ).arg( conv.convert( acctbal ), 10 );
			line.set( 0, str );
			ret->add( line );
		}
		ret->stopLoad();
	}

	return ret;
}

QString TransBalReport::writereport( const QString& title,
																		 const QHaccResultSet * data ){
	QString ret=title;
	if( data->isEmpty() ) ret.append( "\n\tNo Transactions" );
	else{
		for( uint i=0; i<data->rows(); i++ ) ret+="\n"+data->at( i ).gets( 0 );
	}
	return ret;
}

void TransBalReport::selected( QDate&, QDate&, bool& enableacctsel,
															 bool& enablemultiselect ){
	enableacctsel=true;
	enablemultiselect=false;
}

const TransBalInfo TransBalReport::pinfo;
const PluginInfo& TransBalReport::info() const { return pinfo; }

