/************************* * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2005 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************** * * * * * * * * * * * * **************************/

#ifndef SQLITEPLUGIN_H
#define SQLITEPLUGIN_H

#include "sqldbplugin.h"

#ifdef HAVE_CONFIG_H
#include "config.h"
#ifdef SQLITE3
#include "sqlite3.h"
#endif
#else
#include "sqlite.h"
#endif

class QHacc;

class SQLiteInfo : public QHaccSQLDBInfo {
 public:
	SQLiteInfo();
};

/* read and write to SQLite databases */
class SQLiteDBPlugin : public QHaccSQLDBPlugin{
 public:
	static const SQLiteInfo pinfo;
	SQLiteDBPlugin();
	virtual ~SQLiteDBPlugin();

	const PluginInfo& info() const;

	virtual bool connect( QHacc *, const QString&, QString& );

	virtual QString create( const QString& dbname ) const;
	static QString screate( const QString& dbname );

	virtual void startLoad( Table, uint rows =0 );
	virtual void stopLoad( Table );

	auto_ptr<QHaccResultSet> sel( const QString& stmt, vector<ColType> types,
																uint& rows );

	virtual int run( const QString& stmt );
	uint cnt( Table );
	
	void setAtom( AtomicOp, QString ="dbatom" );
	QString sqlField( const TableCol& tc, ColType ct ) const;

 protected:
	QString minmax( Table t, int col, bool max );
#ifdef SQLITE3
	sqlite3 * conn;
#else
	sqlite * conn;
#endif
	int atoms;  // how many atomic ops have been started?

	static int callback( void * unsed, int argc, char **argv, char **azColName );
	
	// convert a SQLite datestring to a QHacc datestring
	static QString convdate( const QString& );
};

#endif
