/************************** * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2005 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************** * * * * * * * * * * * * ***************************/

#include "copystore.h"
#include "guiconstants.h"

#include <iostream>
using namespace std;

QHaccTDrag::QHaccTDrag( const TableRow& t, const QHaccTable& s, uint a, 
												QWidget * p, const char * n )	: QDragObject( p, n ) {
	trans=t;
	splits=QHaccTable( s );
	accountid=a;
}

QHaccTDrag::~QHaccTDrag() {}

const char * QHaccTDrag::format( int index ) const {
	switch( index ){
	case 0:
		return "qhacc/transaction";
		break;
	case 1:
		return "text/plain";
		break;
	default:
		break;
	}
	return 0;
}

QByteArray QHaccTDrag::encodedData( const char * ) const {
	QByteArray data;
	QTextOStream out( data );
	out<<accountid<<endl<<trans.toString()<<endl;
	for( uint i=0; i<splits.rows(); i++ )
	out<<splits[i].toString()<<endl;
	return data;
}

bool QHaccTDrag::decode( QMimeSource * source, TableRow& t, QHaccTable& s, 
												 uint& aid ){
	if( !canDecode( source ) ) return false;

	s=QHaccTable( QC::SCOLS );

	QString str( source->encodedData( "qhacc/transaction" ) );
	QStringList lister=QStringList::split( "\n", str );
	int lineno=0;
	for( QStringList::Iterator it=lister.begin(); it!=lister.end(); ++it ){
		const QString line=*it;
		if( lineno==0 ) aid=line.toUInt();
		else if( lineno==1 ) t=TableRow( line, QC::TCOLS );
		else s.loadRow( line );
		lineno++;
	}
	return true;
}

bool QHaccTDrag::canDecode( QMimeSource * source ){
	return source->provides( "qhacc/transaction" );
}

bool QHaccTDrag::provides( const char * mimetype ) const {
	return ( mimetype=="qhacc/transaction" || mimetype=="text/plain" ) ;
}





QHaccADrag::QHaccADrag( const TableRow& a, QWidget * p, const char * n )	
	: QDragObject( p, n ) {
	account=a;
}

QHaccADrag::~QHaccADrag() {}

const char * QHaccADrag::format( int index ) const {
	switch( index ){
	case 0:
		return "qhacc/account";
		break;
	case 1:
		return "text/plain";
		break;
	default:
		break;
	}
	return 0;
}

QByteArray QHaccADrag::encodedData( const char * ) const {
	QByteArray data;
	QTextOStream out( data );
	out<<account.toString();
	return data;
}

bool QHaccADrag::decode( QMimeSource * source, TableRow& a ){
	if( !canDecode( source ) ) return false;

	QString str( source->encodedData( "qhacc/account" ) );
	a=TableRow( str, QC::ACOLS );
	return true;
}

bool QHaccADrag::canDecode( QMimeSource * source ){
	return source->provides( "qhacc/account" );
}

bool QHaccADrag::provides( const char * mimetype ) const {
	return ( mimetype=="qhacc/account" || mimetype=="text/plain" ) ;
}
