/************************* * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2005 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************** * * * * * * * * * * * * **************************/

#ifndef _QHACCACCTBOXCHOOSER_H
#define _QHACCACCTBOXCHOOSER_H

#include "qhacclistview.h"

#include <memory>
using namespace std;

class QPixmap;

class QHaccABViewItem : public QObject, public QHaccListViewItem {
 public:
	QHaccABViewItem( QHaccListView * );
	~QHaccABViewItem();

	bool acceptDrop( QMimeSource * );
	void dropper( QDropEvent * e );

	void paintCell( QPainter * p, const QColorGroup& cg, int c, int w, int a );
	void paintBranches( QPainter *, const QColorGroup&, int, int, int );

	static void resetE( QHacc * engine );
	void setCurr( bool );

 protected:
	static QColor maincolor, altcolor;
	static auto_ptr<QPixmap> pixmap;
	static bool useanums;

	virtual void iinit();
	virtual void isetRow();

	bool curr;
};


class QHaccAccountBoxChooser : public QHaccListView {
  Q_OBJECT
    public:
  QHaccAccountBoxChooser( QHacc *, QWidget * =0, const char * =0 );
  virtual ~QHaccAccountBoxChooser();

	void save() const;
	void readPrefs( bool );
	void addAccount( const Account& );

 protected:
	QColor color;
	QHaccABViewItem * lasti;

	void paintEmptyArea( QPainter *, const QRect& );

	void contentsDragEnterEvent( QDragEnterEvent * e );
	void contentsDropEvent( QDropEvent * e );
	void startDrag();

	public slots:
		void setAccount( const Account& );

	protected slots:
	void updA( const Account&, const Account& );
	void changeP( const QString&, QColor );
	void selchange( QListViewItem * );

	void renamer( QListViewItem *, int, const QString& );
	void editAcct( QListViewItem *, const QPoint &, int );
	void remAcct( const Account& );
	void remAcct();
	void viewSubset();
	void editAcct();
	void recoAcct();
	void report();
	void chart();

 signals:
  void changedAccount( const Account& );
	void needRecWinOf( const Account& );
	void needSubsetOf( const Account& );
	void needReportOf( const Account& );
	void needGraphOf( const Account& );
	void acctOrderChanged();
};

#endif


