/************************* * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2005 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************** * * * * * * * * * * * * **************************/

#ifndef _QHACCCLI_H
#define _QHACCCLI_H

class QHacc;

/****************************************************************/
/** QHACC Command-line program                                 **/
/**  for the most part, this is just a shell around QHaccExt   **/
/**  library functions                                         **/
/**                                                            **/
/**                                                            **/
/****************************************************************/

class QHaccCLI{
		public:
	QHaccCLI( QHacc * qhacc );
  ~QHaccCLI();
	
	// command-line functions
	void report( int, const char * );
	void report( const char * );
	bool exp( const char * );
	bool imp( const char * );
	void showAccounts();
	void showTrans( const char * );
	bool verify( bool andFix );
	void create( const char * );
	bool reco( const char * );
	void plugins();

 private:
	QHacc * engine;
	bool save();
};

#endif
