/************************** * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2005 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
*************************** * * * * * * * * * * * * **************************/

#ifndef _QHACC_DIALOGS_H
#define _QHACC_DIALOGS_H

#include "plugininfo.h"
#include "qhacctablerows.h"

#include <qframe.h>
#include <qdialog.h>
#include <qtabdialog.h>

class QHacc;
class QLabel;
class MonCon;
class QString;
class QListBox;
class QSplitter;
class QComboBox;
class QCheckBox;
class QLineEdit;
class QCheckBox;
class QGridLayout;
class QPushButton;
class QButtonGroup;
class QRadioButton;
class QHaccLineEdit;
class QHaccDateEdit;
class QHaccAccelEdit;
class QMultiLineEdit;
class QHaccChoiceEdit;
class AccountAreaFrame;

/*********************************************/
/*********** JournalDlg definitions ***********/
/*********************************************/
class JournalDlg : public QDialog {
	Q_OBJECT
		public:
	JournalDlg( QHacc *, const Journal& , QWidget * =0, const char * =0 );
	~JournalDlg();

	static void qremove( QHacc *, const Journal&, QWidget * =0 );

 protected:
	bool edit; 
	Journal journal;
	QHacc * engine;
	QLineEdit * lname, * ldesc;

	private slots:
		void accept();
};

/**********************************************************/
/************ Sched/NamedT Dlg Base definitions ***********/
/**********************************************************/
class LeftDlg : public QDialog {
 Q_OBJECT
	 public:
 LeftDlg( QHacc *, QWidget * =0, const char * =0 );
 virtual ~LeftDlg();
 
 void setListItems( const QStringList& );
 void addListItem( const QString& );
 void setRightSide( QFrame * );

 protected:
 QHacc * engine;
 QListBox * listbox;
 QSplitter * splitter;

 virtual void iselect( const QString& );
 virtual void iaccept();
 virtual void iremakeList();

 protected slots:
	 void listsel( const QString& );
 void accept();
 void remakeList();
};

/*********************************************/
/************ SchedDlg definitions ***********/
/*********************************************/
class SchedFrame : public QFrame {
	Q_OBJECT
		public:
	SchedFrame( QHacc * e, QWidget * =0, const char * =0 );
	~SchedFrame();
	
	void setJob( const TableRow&, const QString& n );
	
 protected:
	QLineEdit * freq, * onefreq;
	QHacc * engine;
	TableRow job;
	QString name;
	QButtonGroup * schedbox;
	QPushButton * apply;
	QLabel * nextrun, * title;
	QRadioButton * day, * mon, * bim, * qtr, * one, * non, * lastday;

	int getFreq() const;

	static const QString NEVER;
	public slots:
		void accept();
	void setNext( int );
	void toggle( int );
	void texter( const QString& );
};

class SchedDlg : public LeftDlg {
	Q_OBJECT
		public:
	SchedDlg( QHacc *, const QString&, QWidget * =0, const char * =0 );
	~SchedDlg();

 protected:
	QHaccTable * ntrans;
	SchedFrame * right;

	void iselect( const QString& );
	void iaccept();
	void iremakeList();

	protected slots:
		void tmod( const Transaction& );
};


/********************************************/
/*********** NamedDlg definitions ***********/
/********************************************/
class NamedFrame : public QFrame {
	Q_OBJECT
		public:
	NamedFrame( QHacc * e, uint lid, QWidget * =0, const char * =0 );
	~NamedFrame();
	
	void setTrans( const QString& n );
	static const char * NEWY;
	
 protected:
	uint lid;
	bool edit; 
	QHacc * engine;
	QHaccLineEdit * name, * memo;
	QHaccAccelEdit * shortcut;
	QHaccChoiceEdit * payee, * acctedit, * num;
	AccountAreaFrame * area;
	Transaction mynt;
	QPushButton * apply, * rem;

	private slots:
		void accept();
	void remove();
	void cacct( const QString& );
};

class NamedDlg : public LeftDlg {
	Q_OBJECT
		public:
	NamedDlg( QHacc *, uint journalid, const QString& n, QWidget * =0,
						const char * =0 );
	~NamedDlg();

	protected slots:
		void tmod( const Transaction& );

 protected:
	NamedFrame * right;

	void iselect( const QString& );
	void iaccept();
	void iremakeList();
};


/* * * * * * * * * * * * * * * * * */
/* * * * * Plugin Selector * * * * */
/* * * * * * * * * * * * * * * * * */
class PluginSelector : public QFrame {
	Q_OBJECT
		public:
	PluginSelector( QHacc * engine, int pitype, QWidget * =0, 
									int defaultsel =-1, const char * =0 );
	~PluginSelector();
	
	PluginInfo getSelectedInfo() const;
	void setTitle( const QString& );
	int getButtonID() const;

 protected:
	map<int, PluginInfo> plugini;	
	QButtonGroup * formater;
};


/* * * * * * * * * * * * * * * * */
/* * * * * Home Selector * * * * */
/* * * * * * * * * * * * * * * * */

class HomeDlg : public QDialog {
	Q_OBJECT
 public:
	static auto_ptr<HomeDlg> homedlg( QHacc * engine, QWidget * =0,
																		const char * n =0 );
	~HomeDlg();

	virtual QString home( bool * okay =0 ) const;
	virtual void dolayout() =0;

 protected:
	HomeDlg( QHacc * engine, int pitype, QWidget * p =0, const char * n =0 );

	QHacc * engine;
	PluginSelector * pisel;
  QPushButton * browsebtn, * okay, * cancel;
  QLineEdit * filename;
  QLabel * fdlbl;

	QString queryHomeDlg();

	protected slots:
		void openFD();
};

/***********************************************/
/*********** QHaccHomeDlg definition ***********/
/***********************************************/
class QHaccHomeDlg : public HomeDlg {
  Q_OBJECT
    public:
  QHaccHomeDlg( QHacc * e, QWidget * =0, const char * =0 );
  ~QHaccHomeDlg();

  void dolayout();
};

#endif
