/************************** * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2005 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************** * * * * * * * * * * * * ***************************/

#include "qhacc.h"
#include "qhaccutils.h"
#include "qhaccwidget.h"

#include <iostream>
#include <stdlib.h>
#include <locale.h>

#include <qapplication.h>
#include <qtextstream.h>
#include <qtextcodec.h>

void helpQuit( const char * progname ){
  cout<<"usage: "<<progname<<" <QHACC_ROOT> <QHACC_HOME> [options]"<<endl
			<<"options:"<<endl
			<<" [-l             <Language Directory>   set QHacc's locale"<<endl
			<<" [--debug        <Level>]               set debugging output"<<endl;
  exit ( EXIT_SUCCESS );
}

char * opt( int argc, char ** argv, int& i ){
	i++;
	if( i<argc ) return argv[i];
	else helpQuit( argv[0] );
	return 0;
}

bool cmp( const char * model, const char * test ){
	return ( strcmp( model, test )==0 );
}

int main( int argc, char **argv ){
	//cout<<argc<<" arguments"<<endl;
	//for( int i=0; i<argc; i++ ) cout<<i<<": "<<argv[i]<<" ";
	//cout<<endl;

	char * qroot=getenv( "QHACC_ROOT" );
	char * qhome=getenv( "QHACC_HOME" );

	if( !qroot ){
		cerr<<"QHACC_ROOT environment variable not set"<<endl;
		return EXIT_FAILURE;
	}

	QHacc qhacc( qroot );

	const char * langdir=qhacc.languagedir();
	if( !langdir ) langdir=getenv( "QHACC_LANGDIR" );

  cout<<"QHacc, "
			<<"Copyright (C) 2005 Ryan Bobko <ryan@ostrich-emulators.com>"<<endl
      <<"QHacc comes with ABSOLUTELY NO WARRANTY; for details type `"
      <<"qhacc -w'."<<endl
      <<"This is free software, and you are welcome to redistribute it"
			<<" under"<<endl
      <<"certain conditions; Please see the GNU Public License "
      <<"for details."<<endl;

	// set the home if we're not called with any arguments
	if( argc==1 && !qhacc.setHome( qhome ) ) return EXIT_FAILURE;

	// now that that's out of the way, actually parse the command line
	// if debug is the first arg, set it before setting the home. otherwise,
	// set the home before parsing any args
	for( int i=1; i<argc; i++ ){
		if( i==1 ){
			if( cmp( argv[i], "--debug" ) ){
				if( i+1>=argc ) helpQuit( argv[0] );
				Utils::setDebug( QString( argv[i+1] ).toInt() );
			}
			if( !qhacc.setHome( qhome ) ) return EXIT_FAILURE;
		}
		if( cmp( argv[i], "--debug" ) ){
			Utils::setDebug( QString( opt( argc, argv, i ) ).toInt() );
		}
		else if( cmp( argv[i], "-l" ) ) langdir=opt( argc, argv, i );
		else helpQuit( argv[0] );
	}

	QApplication a( argc, argv );

	QTranslator translator( 0 );
	if( langdir ){
		std::ostream * str=0;
		if( Utils::debug( Utils::DBGMAJOR, str ) ) 
			*str<<"locale is "<<QTextCodec::locale()<<"; QHACC_LANDGIR is "
					<<langdir<<endl;
		
		setlocale( LC_ALL, "" );
		translator.load( QString( "qhacc_" )+QTextCodec::locale(), langdir );
		a.installTranslator( &translator );
	}
	
	QHaccWidget * q=new QHaccWidget( &qhacc );
	q->show();
	a.connect( &a, SIGNAL( lastWindowClosed() ), &a, SLOT( quit() ) );
	int i=a.exec();
	return i;
}
