/************************** * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2005 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************** * * * * * * * * * * * * ***************************/
#ifndef _QHACCLINEEDITS_H
#define _QHACCLINEEDITS_H

#include <qlabel.h>
#include <qdatetime.h>
#include <qlineedit.h>
#include <qvalidator.h>
#include <qstringlist.h>

class QListBox;
class QListBoxItem;
class QKeyPressEvent;
class QFocusEvent;

class MonCon;

class QHaccLineEdit : public QLineEdit {
  Q_OBJECT
    public:
  QHaccLineEdit( QWidget *, const char * =0 );
  QHaccLineEdit( const QString&, QWidget *, const char * =0 );
  virtual ~QHaccLineEdit();

	virtual void setEmptyText( const QString& );
	void setText( const QString& );
	QString text() const;
	void selectAllOnFocus( bool );

 protected:
  virtual void focusInEvent( QFocusEvent * );
  virtual void focusOutEvent( QFocusEvent * );

	QString empty;
  
 private:
	bool dosel;

 signals:
  void gainedFocus();
};


class QHaccChoiceEdit : public QHaccLineEdit {
  Q_OBJECT
    public:
  QHaccChoiceEdit( bool, QWidget * =0, const char * =0 );
  virtual ~QHaccChoiceEdit();
  
  void insertItem( const QString& );
  void insertStringList( QStringList );
	void ignoreCase( bool );
  void remove( QString );
  void clear();

 protected:
  bool event( QEvent * );
  virtual void keyPressEvent( QKeyEvent * );
	void createListBox();
	void removeListBox();

	QString prefixer;
	QListBox * listBox;

 private:
  int index;
  QStringList strings;
  bool allowInserts, nocase, ignorecomplete;

 signals:
  void activated ( int index ) ;
  void activated ( const QString & );
	
  public slots:
    void complete();
	void itemChosen( QListBoxItem *item );
	void itemHighlighted( QListBoxItem *item );
};

class QHaccMoneyEdit : public QHaccChoiceEdit {
 public:
  QHaccMoneyEdit( const MonCon& c, QWidget * =0, const char * =0 );
  virtual ~QHaccMoneyEdit();
  virtual void focusOutEvent( QFocusEvent * );

 protected:
	int total, focusoutterm;
	const MonCon * conv;
	bool add, sub, blanktext;

  virtual void keyPressEvent( QKeyEvent * );
};

class QHaccDateEdit : public QHaccLineEdit {
  Q_OBJECT
    public:
  QHaccDateEdit( QWidget *, const char * =0 );
  QHaccDateEdit( const QDate&, QWidget *, const char * =0 );
  virtual ~QHaccDateEdit();

  enum DateFormat { AMERICAN, EUROPEAN, YEARFIRST };
 
  QDate getDate() const;
  void setDate( const QDate& );
  bool event( QEvent * );

  static QString getDateString( const QDate& );
  static QDate getDateFromString( const QString& );
  static QDate getValidDateFromString( const QString& );
  
  static DateFormat getDateFormat();
  static QString getDateSeparator();

 protected:
  virtual void focusInEvent( QFocusEvent * );
  virtual void focusOutEvent( QFocusEvent * );

 private:
  static DateFormat form;
	static QString sep, AmForm, EuForm, YfForm;

  QDate day;

  public slots:
    static void setDateFormat( DateFormat );
  static void setDateSeparator( const QString& );
  void refresh();

 signals:
  void dateChanged( QDate );
};

class QHaccAccelEdit : public QHaccLineEdit {
 public:
  QHaccAccelEdit( QWidget *, const char * =0 );
  QHaccAccelEdit( const QString&, QWidget *, const char * =0 );
  virtual ~QHaccAccelEdit();

 protected:
	void keyPressEvent( QKeyEvent * );
};


class QHaccDateValidator : public QValidator {
 public:
	QHaccDateValidator( QWidget * =0, const char * =0 );
	~QHaccDateValidator();

	QValidator::State validate( QString &, int & ) const;
};

class QHaccChoiceValidator : public QValidator {
 public:
	QHaccChoiceValidator( QStringList *, QHaccChoiceEdit * =0, const char * =0 );
	~QHaccChoiceValidator();

	QValidator::State validate( QString &, int & ) const;

 protected:
	QStringList * list;
};


#endif
