/************************* * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2005 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************** * * * * * * * * * * * * **************************/

#include "qhacclistview.h"
#include "qhacc.h"
#include "qhaccutils.h"
#include "qhacctable.h"
#include "qhacclistview.moc"

#include <qevent.h>
#include <qcursor.h>
#include <qheader.h>
#include <qpainter.h>
#include <qpopupmenu.h>

QHacc * QHaccListViewItem::engine=0;

QHaccListViewItem::QHaccListViewItem( QHaccListView * p ) : QListViewItem( p ){
	iinit();
}
QHaccListViewItem::QHaccListViewItem( QHaccListViewItem * p ) 
	: QListViewItem( p ){ 
	iinit();
}
QHaccListViewItem::~QHaccListViewItem(){}
void QHaccListViewItem::iinit(){ idcol=0; }
const TableRow& QHaccListViewItem::row() const { return myrow; }
void QHaccListViewItem::setRow( const TableRow& r ){ 
	// we might be changing this item's id, so unregister the old one first
	uint oldid=myid();

	// set if the row
	myrow=r;
	for( int i=0; i<r.cols(); i++ ) setText( i, myrow[i].gets() );

	// and finally, register this row's id
	if( myid()!=oldid ){
		QHaccListView * lv=( QHaccListView * )listView();
		
		lv->unregisterItem( oldid );
		lv->registerItem( myid(), this );
	}

	isetRow();
}

void QHaccListViewItem::resetE( QHacc * e ){ engine=e; }

uint QHaccListViewItem::myid() const {
	if( myrow.isNull() ) return 0;
	else return myrow[idcol].getu();
}

void QHaccListViewItem::isetRow(){}






QHaccListView::QHaccListView( QHacc * eng, QWidget * p, const char * n ) 
	: QListView( p, n ){
	
	engine=eng;

	// readprefs makes this false to avoid unnecessary saves at startup
	nosaves=true; 

	setSelectionMode( Single );

  viewport()->setFocusPolicy( StrongFocus );
  viewport()->setMouseTracking( true );  

	setDragAutoScroll( true );

	connect( this, SIGNAL( onItem( QListViewItem * ) ),
					 this, SLOT( mouser( QListViewItem * ) ) );
	connect( this, SIGNAL( currentChanged( QListViewItem * ) ),
					 this, SLOT( mouser( QListViewItem * ) ) );
	connect( this, SIGNAL( contextMenuRequested( QListViewItem *, const QPoint&,
																							 int ) ),
					 this, SLOT( popper( QListViewItem *, const QPoint&, int ) ) );

	QHeader * head=header();
	head->setTracking( false );
	connect( head, SIGNAL( sizeChange( int, int, int ) ), SLOT( ssave() ) );
	connect( head, SIGNAL( indexChange( int, int, int ) ), SLOT( ssave() ) );
}

QHaccListView::~QHaccListView(){}

TableRow QHaccListView::getSelected() const {
	QHaccListViewItem * avi=( QHaccListViewItem * )selectedItem();
	return ( avi ? avi->row() : TableRow() );
}

void QHaccListView::grabData(){}
void QHaccListView::makeData(){
	items.clear();
	grabData(); 
}

const TableRow& QHaccListView::getMoused() const { return contextTarget; }
void QHaccListView::mouser( QListViewItem * i ){
	if( i ) contextTarget=getRow( i );
}

void QHaccListView::popper( QListViewItem * i, const QPoint& p, int ){
	if( popup.get()!=0 ){
		QHaccListViewItem * avi=( QHaccListViewItem * )i;
		if( avi ) contextTarget=avi->row();
		popup->popup( p );
	}
}

void QHaccListView::ssave(){ save(); }
void QHaccListView::isave() const {}
void QHaccListView::ireadPrefs( bool ){}
void QHaccListView::setPopup( QPopupMenu * p ){ popup.reset( p ); }

void QHaccListView::save() const { 
	if( !( nosaves || prefbase.isEmpty() ) ){
		//cout<<"saving prefs for "<<prefbase<<endl;
		QHeader * head=header();
		int hc=head->count();
		QString tmp, sizeval, orderval;
		for( int i=0; i<hc; i++ ){
			orderval+=tmp.setNum( head->mapToIndex( i ) )+" ";
			sizeval+=tmp.setNum( columnWidth( i ) )+" ";
		}
		engine->setSP( prefbase+"HEADINGSIZES", sizeval );
		engine->setSP( prefbase+"HEADINGORDER", orderval );
#if QT_VERSION<320
		engine->setIP( prefbase+"SORTCOL", sortcol );
		engine->setBP( prefbase+"SORTASC", sortasc );
#else
		engine->setIP( prefbase+"SORTCOL", sortColumn() );
		engine->setBP( prefbase+"SORTASC", sortOrder()==Ascending ? true : false );
#endif
		isave(); 
	}
}

void QHaccListView::setPrefBase( const QString& s ){ prefbase=s; }

#if QT_VERSION<320
void QHaccListView::setSorting( int c, bool a ){
	sortcol=c;
	sortasc=a;
	QListView::setSorting( c, a );
}
#endif

void QHaccListView::readPrefs( bool initial ){ 
	if( !prefbase.isEmpty() ){
		//cout<<"reading prefs for "<<prefbase<<endl;

		// heading sizes first
		QString ss=engine->getSP( prefbase+"HEADINGSIZES" );
		const int num=header()->count();
		QString * vals=new QString[num];

		header()->setStretchEnabled( true, num-1 );

		if( !ss.isEmpty() ){
			Utils::parser( ss, " ", 0, vals, num );
			for( int i=0; i<num; i++ ){
				int valsz=vals[i].toInt();
				setColumnWidth( i, valsz );
				setColumnWidthMode( i, Manual );
				header()->adjustHeaderSize();
			}
		}

		// header index locations
		QString hix=engine->getSP( prefbase+"HEADINGORDER" );
		if( !hix.isEmpty() ){
			Utils::parser( hix, " ", 0, vals, num );
			QHeader * head=header();
			for( int i=0; i<num; i++ ){
				int valsz=vals[i].toInt();
				head->moveSection( i, valsz );
			}
		}
		delete [] vals;

		// sorting stuff
		int indexer=engine->getIP( prefbase+"SORTCOL" );
		bool asc=engine->getBP( prefbase+"SORTASC" );
		setSorting( indexer, asc );
	}

	ireadPrefs( initial ); 

	nosaves=false;
}

TableRow QHaccListView::getRow( QListViewItem * i ) const {
	if( i ) return ( ( QHaccListViewItem * )i )->row();
	else return TableRow();
}

QHaccListViewItem * QHaccListView::findRowItem( uint id ){ 
	/*
	cout<<"looking for listview id "<<id<<endl;
	map<uint, QHaccListViewItem *>::iterator it;
	cout<<"items map contains:"<<endl;
	for( it=items.begin(); it!=items.end(); it++ ){
		cout<<"  "<<getRow( it->second ).toString()<<endl;
	}
	cout<<"--"<<endl;
	*/
	if( items[id]==items.end()->second ) return 0;
	else return items[id];
}

void QHaccListView::registerItem( uint id, QHaccListViewItem * it ){
	if( id==0 ) return;
	items[id]=it;
}

void QHaccListView::unregisterItem( uint id ){
	if( id==0 ) return;
	items[id]=0;
}

