/************************* * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2005 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************** * * * * * * * * * * * * **************************/

#ifndef _QHACCWIDGET_H
#define _QHACCWIDGET_H

#include "qhacctablerows.h"

#include <qmainwindow.h>

class QHacc;
class QHaccView;
class QHaccJournalChooser;
class QHaccAccountBox;

class QLabel;
class QToolBar;
class QCheckBox;
class QComboBox;
class QPopupMenu;
class QDockWindow;

/******************************************/
/******** QHaccWidget definitions *********/
/******************************************/

class QHaccWidget : public QMainWindow {
  Q_OBJECT
    public:
  QHaccWidget( QHacc *, QWidget * =0, const char * =0 );
  ~QHaccWidget();

	bool save();

 private:
	QHacc * engine;
	Account account;
	Journal journal;
	QToolBar * tools;
  QLabel * abalance, * tcount, * msgs, * saveflag;
	bool autosave;
  QHaccView * viewer;
  QHaccAccountBox * chooser;
	QHaccJournalChooser * journaler;
	QDockWindow * cdock, * jdock;

	void readPrefs( bool firstTime );
	void igrd( const Account&, int type );
	void connectView( QHaccView * );
	void savedockloc( const QString& pref, QDockWindow * dw );
	void readdockloc( const QString& pref, QDockWindow * dw );

 signals:
		void transToClipboard( bool );

  public slots:
		void show();
	void saveAndQuit();
	void quit();
  void setJournal( const Journal& );
  void setAccount( const Account& );
  void updateAccount( const Account&, const Account& );
	void changePref( const QString&, QString );
	void changePref( const QString&, QFont );
	void changePref( const QString&, bool );
	void OBAccount( const Account&, int );
	void setSaveFlag( bool );

	void removeOpened();
  void report( const Account& );
  void graph( const Account& );
	void subset( const Account& );
	void reconcile( const Account& );

	void toggleCurrency();
	void toggleRecBal();
	void changePrefs();
  void reconcile();
  void editAcct();
	void newAcct();
	void plugins();
  void aboutQt();
  void reload();
	void subset();
  void report();
  void graph();
  void about();
  void ssave();
	void transOnClipboard( bool );

	void newLed();
	void remLed();
	void editLed();

	void openNTrans();
	void openSched();
};

#endif
