/*
*  RAL -- Rubrica Addressbook Library
*  file: net.h
*  
*  Copyright (C) Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 3 of the License
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef _R_NET_ADDRESS_H
#define _R_NET_ADDRESS_H

#include <glib.h>
#include <glib-object.h>
 

#define R_NET_ADDRESS_TYPE            (r_net_address_get_type())

#define R_NET_ADDRESS(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj),     \
				       R_NET_ADDRESS_TYPE, RNetAddress))

#define R_NET_ADDRESS_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass),      \
                                       R_NET_ADDRESS_TYPE, RNetAddressClass))

#define IS_R_NET_ADDRESS(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj),     \
                                       R_NET_ADDRESS_TYPE))

#define IS_R_NET_ADDRESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass),      \
                                       R_NET_ADDRESS_TYPE))

#define R_NET_ADDRESS_GET_CLASS(kls)  (G_TYPE_INSTANCE_GET_CLASS((kls),      \
                                       R_NET_ADDRESS_TYPE, RNetAddressClass))


typedef struct _RNetAddress        RNetAddress;
typedef struct _RNetAddressClass   RNetAddressClass;
typedef struct _RNetAddressPrivate RNetAddressPrivate;



typedef enum {
  R_NET_ADDRESS_WEB = 0,
  R_NET_ADDRESS_EMAIL,
  R_NET_ADDRESS_EKIGA,
  R_NET_ADDRESS_IRC,
  R_NET_ADDRESS_IRC_AIM,
  R_NET_ADDRESS_IRC_ICQ,
  R_NET_ADDRESS_IRC_JABBER,
  R_NET_ADDRESS_IRC_YAHOO,
  R_NET_ADDRESS_IRC_MSN,
  R_NET_ADDRESS_WORK_WEB,
  R_NET_ADDRESS_WORK_EMAIL,
  R_NET_ADDRESS_UNKNOWN
} RNetAddressType;



struct _RNetAddress {
  GObject parent;

  RNetAddressPrivate* priv;
};


struct _RNetAddressClass {
  GObjectClass parent;
};


GType           r_net_address_get_type    (void);


RNetAddress*    r_net_address_new         (void);
void            r_net_address_free        (RNetAddress *net);

gboolean        r_net_address_check       (RNetAddress* net, 
					   const gchar* property, 
					   gchar** value);
gboolean        r_net_address_search      (RNetAddress *net, const gchar* str);

RNetAddress*    r_net_address_copy        (RNetAddress *net);

gchar*          r_net_address_decode_type (RNetAddressType type);
RNetAddressType r_net_address_encode_type (gchar* type);


#endif
