/*
*  file: plugin.h
*  
*
*  Copyright (C) 2005 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 3 of the License
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef _R_PLUGIN_H
#define _R_PLUGIN_H

#include <glib.h>
#include <glib-object.h>

#include "types.h"
#include "filter.h"

#define R_PLUGIN_TYPE            (r_plugin_get_type())

#define R_PLUGIN(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj),  \
				  R_PLUGIN_TYPE, RPlugin))

#define R_PLUGIN_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass),   \
                                  R_PLUGIN_TYPE, RPluginClass))

#define IS_R_PLUGIN(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj),  \
                                  R_PLUGIN_TYPE))

#define IS_R_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass),   \
                                  R_PLUGIN_TYPE))

#define R_PLUGIN_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj),   \
                                  R_PLUGIN_TYPE, RPluginClass))


typedef struct _RPlugin          RPlugin;
typedef struct _RPluginClass     RPluginClass;
typedef struct _RPluginPrivate   RPluginPrivate;


/* il tipo "plugin_init" descrive una funzione che prende un 
   argomento di tipo Plugin, e non restituisce alcun valore
*/
//typedef void (*RPluginInit) (RPlugin* plugin);


/**
 * RPluginAction
 * @name: gchar*, the action's name
 * @handle: gchar*, handle to a function.
 * 
 * RPluginAction is used to manage the action that a plugin can make
 * 
 * examples (from rubrica's plugin):
 * action->name   = g_strdup("read");
 * action->handle = (gpointer) r_rubrica_open_file;
 */
typedef struct _plugin_action {
  gchar* name; 
  gchar* handle;  
} RPluginAction;



struct _RPlugin 
{
  GObject parent;

  RPluginPrivate* priv; 
};


struct _RPluginClass
{
  GObjectClass parent;
  
  /* methods */
  void (*run_configure_gui) (gpointer);
};


GType    r_plugin_get_type          (void);


RPlugin* r_plugin_new               (void);
void     r_plugin_free              (RPlugin* plugin);

// gboolean r_plugin_load              (RPlugin* plugin, const gchar* file);

void     r_plugin_set_engine        (RPlugin* plugin, gpointer obj);
gpointer r_plugin_get_engine        (RPlugin* plugin);

void     r_plugin_add_action        (RPlugin* plugin, RPluginAction* action);
void     r_plugin_add_filter        (RPlugin* plugin, RFilter* filter);

gpointer r_plugin_get_handle        (RPlugin* plugin, gchar* name);
GList*   r_plugin_get_filters       (RPlugin* plugin);

gchar*   r_plugin_get_name          (RPlugin* plugin);
gchar*   r_plugin_get_label         (RPlugin* plugin);
gchar*   r_plugin_get_info          (RPlugin* plugin);

gchar*   r_plugin_get_file_name     (RPlugin* plugin);

gboolean r_plugin_is_configurable   (RPlugin* plugin);
void     r_plugin_run_configure_gui (RPlugin* plugin);


#endif
