/*
*  RAL -- Rubrica Addressbook Library
*  file: csv.h
*  
*  Copyright (C) Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 3 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef _R_CSV_GMAIL_UTF16_H
#define _R_CSV_GMAIL_UTF16_H

#include <stdio.h>
#include <glib.h>
#include <glib-object.h>
#include <gmodule.h>

#include "csv_engine.h"
#include "abook.h"
#include "error.h"
#include "plugin.h"


#define R_CSV_GMAIL_TYPE            (r_csv_gmail_get_type())

#define R_CSV_GMAIL(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj),  \
                                     R_CSV_GMAIL_TYPE, RCsvGmail))

#define R_CSV_GMAIL_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass),   \
                                     R_CSV_GMAIL_TYPE, RCsvGmailClass))

#define IS_R_CSV_GMAIL(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj),  \
                                     R_CSV_GMAIL_TYPE))

#define IS_R_CSV_GMAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass),   \
                                     R_CSV_GMAIL_TYPE))

#define R_CSV_GMAIL_GET_CLASS(obj)  (G_TYPE_CHECK_INSTANCE_GET_CLASS((obj), \
                                     R_CSV_GMAIL_TYPE, RCsvGmailClass))


typedef struct _RCsvGmail          RCsvGmail;
typedef struct _RCsvGmailClass     RCsvGmailClass;
typedef struct _RCsvGmailPrivate   RCsvGmailPrivate;


struct _RCsvGmail 
{
  RCsvEngine parent;
  
  /* private */
  RCsvGmailPrivate* priv;
};


struct _RCsvGmailClass
{
  RCsvEngineClass parent;
};


GType r_csv_gmail_get_type   (void);



G_MODULE_EXPORT void plugin_init (RPlugin* plugin, gchar* file);
G_MODULE_EXPORT void plugin_fini (void);

#endif  /* _R__CSVGMAIL_UTF16_H */ 
